/**
 * Copyright code ( http://wonderfl.net/user/code )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6fPI
 */

// forked from matacat's forked from:  [最適化 Tips] 演算した値をインデックスにする際の留意事項
// forked from sekiryou's  [最適化 Tips] 演算した値をインデックスにする際の留意事項
// forked from muta244's [最適化 Tips] 変数名の長さによる処理速度の違い
/*
 *  テキストの座標を格納していく際に、
 * 　pushを使って代入するべきか、
 * 　カウンターで加算処理してインデックスを指定して代入したらいいのか、
 * 　迷ったのでテスト。
 * 　インデックス指定が一番早いのはわかっていましたが、
 * 　長さを測って代入するのが早そうですね。
 * 
 * 
 * 
 */

package {

import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

import flash.geom.Matrix;
public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 1000000;
    
    private function _init():void
    {
        _debug(
            "各テスト" + _NUM_TIMES.toString() + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
		var tmpVector1:Vector.<Number> =new Vector.<Number>();
        var tmpVector2:Vector.<Number> = new Vector.<Number>();
		var tmpVector3:Vector.<Number> =new Vector.<Number>();
		var tmpVector4:Vector.<Number> =new Vector.<Number>();
		var cnt:Number =0;
		
		_measure(" ループのみ ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
			}
		});
		_measure(" pushで代入", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				tmpVector1.push(i);
			}
		});
		_measure(" indexを指定して代入 ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				tmpVector2[i] = i;
			}
		});
		_measure(" index指定に加算処理が入った場合 ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				tmpVector3[cnt] = i;
				cnt++;
			}
		});
		_measure(" 最後列を指定して代入した場合 ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				tmpVector4[int(tmpVector4.length)] = i;
			}
		});
        
        
        _debug("\n結果については言及しませんが、\nこのテストスクリプト最高でございます！\n使わせていただきました。ありがとうございました！");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
