/**
 * Copyright ivan.belchev ( http://wonderfl.net/user/ivan.belchev )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6fJP
 */

// forked from sakef's 簡単ドット地球儀
/*
    簡単ドット地球儀。
*/
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.events.Event;
    import net.wonderfl.utils.SequentialLoader;
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
    public class Main extends BasicView
    {
        private static const IMG:String = "http://assets.wonderfl.net/images/related_images/5/5c/5ce4/5ce43791031655e75d33c8a6382dc1429fb4fb76";
        private static const N_POINT1:int=150;
        private static const N_POINT2:int=100;
        private var pixels:Pixels;
        private var imgs:Array
        
        // コンストラクタ
        public function Main()
        {            
            super(465, 465, true, true);
            
            // 画像ロード
            imgs = [];
            SequentialLoader.loadImages([IMG], imgs, init);
        }
        
        // 色々初期化する関数
        private function init():void
        {
            // レイヤーの用意
            var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 465, 465, true, 0, BitmapClearMode.CLEAR_PRE, true);
            layer.clearBeforeRender=true;
            viewport.containerSprite.addLayer(layer);
            
            // カメラの設定・Pixelsの初期化
            camera.z=-500;
            pixels=scene.addChild(new Pixels(layer)) as Pixels;
            
            // 世界地図画像の初期化
            var ldr:Loader=imgs.pop();
            var source:BitmapData = (ldr.content as Bitmap).bitmapData;
            
            // 座標を計算して、Pixel3Dを作成
            for(var i:int=0; i < N_POINT1; i++)
            {
                var theta1:Number=(360 / N_POINT1) * i * Math.PI / 180;
                for(var j:int=0; j < N_POINT2; j++)
                {
                    // 座標計算
                    var theta2:Number=((180 / N_POINT2) * j - 90) * Math.PI / 180;
                    var xx:Number=230 * Math.cos(theta2) * Math.sin(theta1);
                    var yy:Number=230 * Math.sin(theta2);
                    var zz:Number=230 * Math.cos(theta2) * Math.cos(theta1);
                    
                    // 色計算 & Pixel3D作成
                    var color:uint = (source.getPixel(i, j) == 0xffffff)?(0xff0000ff):(0xff00ff00);
                    pixels.addPixel3D(new Pixel3D(color, xx, yy, zz));
                }
            }
            
            // フレームイベント
            addEventListener(Event.ENTER_FRAME, onFrame);
        }
        
        // レンダリング
        private function onFrame(e:Event):void
        {
            pixels.rotationX --;
            pixels.rotationY --;
            singleRender();
        }
    }
}