/**
 * Copyright hi.kurosawa ( http://wonderfl.net/user/hi.kurosawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6eta
 */

package {
    //----------------------------------------------
    //デジタル数字の時計
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;
//    import cls.*;
    public class clock extends Sprite {
        private var arrNum:Array;
        private var btn24H:clsButton;
        private var btnAMPM:clsButton;
        private var txfAM:TextField;
        private var txfPM:TextField;
        // 24H,AM/PM
        private var bolAP24:Boolean;
        public function clock():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void         {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            var i:int;
            var numX:Number;
            var numY:Number;
            var numSiz:Number;
            var ledNum:clsLedNum;
            arrNum = new Array();
            bolAP24 = true;        //24H

            //年月日の表示
            numX = 5;
            numY = 5;
            numSiz = 25;
            for (i = 0; i < 8; i++) {
                ledNum = new clsLedNum("0",numX,numY,numSiz,15);
                addChild(ledNum);
                arrNum.push(ledNum);
                numX += 30*numSiz/25.0;
                if (i == 3 ) {
                    addChild(fncText("年", 20, numX, numY + 25, 0x00ff00));
                    numX += 30*numSiz/25.0;
                }
                if ( i == 5 ) {
                    addChild(fncText("月", 20, numX, numY + 25, 0x00ff00));
                    numX += 30*numSiz/25.0;
                }
                if ( i == 7) {
                    addChild(fncText("日", 20, numX, numY + 25, 0x00ff00));
                    numX += 30*numSiz/25.0;
                }
            }
            numX = 5;
            numY += numSiz*2+5;
            numSiz = 40;
            txfAM = fncText("AM", 20, numX, numY + 39, 0x00ff00);
            addChild(txfAM);
            txfPM = fncText("MP", 20, numX, numY + 58, 0x00ff00);
            addChild(txfPM);
            numX += 40;
            
            for (i = 0; i < 6; i++) {
                ledNum = new clsLedNum("0",numX,numY,numSiz,15);
                addChild(ledNum);
                arrNum.push(ledNum);
                numX += 30*numSiz/25.0;
                if (i==1) {
                    var ledKug:clsLedKugiri = new clsLedKugiri(":",numX,numY,numSiz,15);
                    addChild(ledKug);
                    numX += 10 * numSiz / 25.0;
                }
                if (i == 3) {
                    numSiz = 25;
                    numX += 5 * numSiz / 25.0;
                    numY += (40 - 25)*2;
                }
            }
            btn24H = new clsButton("24H" , 10, 150, 80, 20,on24H);
            addChild(btn24H);
            btnAMPM = new clsButton("AM/PM" , 100, 150, 80, 20,onAMPM);
            addChild(btnAMPM);
            
            //繰り返しに時刻の表示関数
            addEventListener(Event.ENTER_FRAME, onTime);
        }
        //時刻の表示
        private function onTime(e:Event):void {
            var datNow:Date = new Date();
            var intFullYear:int = datNow.fullYear;
            arrNum[0].setVal((int(intFullYear / 1000) % 10).toString());
            arrNum[1].setVal((int(intFullYear / 100) % 10).toString());
            arrNum[2].setVal((int(intFullYear / 10) % 10).toString());
            arrNum[3].setVal((int(intFullYear ) % 10).toString());
            var intMonth:int = datNow.getMonth()+1;
            arrNum[4].setVal((int(intMonth / 10) % 10).toString());
            arrNum[5].setVal((int(intMonth ) % 10).toString());
            var intDate:int = datNow.getDate();
            arrNum[6].setVal((int(intDate / 10) % 10).toString());
            arrNum[7].setVal((int(intDate ) % 10).toString());
            var intHours:int = datNow.getHours();
            if (bolAP24 == true) {
                btn24H.enable(false);
                btnAMPM.enable(true);
                txfAM.visible = false;
                txfPM.visible = false;
            } else {
                if (intHours >= 12) { 
                    intHours -= 12; 
                    txfAM.visible = false;
                    txfPM.visible = true;
                } else {
                    txfAM.visible = true;
                    txfPM.visible = false;
                }
                btn24H.enable(true);
                btnAMPM.enable(false);
                
            }
            arrNum[8].setVal((int(intHours / 10) % 10).toString());
            arrNum[9].setVal((int(intHours ) % 10).toString());
            
            
            var intMinutes:int = datNow.getMinutes();
            arrNum[10].setVal((int(intMinutes / 10) % 10).toString());
            arrNum[11].setVal((int(intMinutes ) % 10).toString());
            var intSeconds:int = datNow.getSeconds();
            arrNum[12].setVal((int(intSeconds / 10) % 10).toString());
            arrNum[13].setVal((int(intSeconds ) % 10).toString());
        }
        private function on24H(e:MouseEvent):void {
            bolAP24 = true;        //24h
        }
        private function onAMPM(e:MouseEvent):void {
            bolAP24 = false;        //am/pm
        }
        //固定文字文字列表示関数
        // sText:表示文字列
        // nSiz:文字サイズ
        // nx,ny:文字位置
        // uic:カラー
        // 戻り値:作成TextField    
        private function fncText(sText:String , nSiz:Number,nx:int,ny:int,uic:uint):TextField {
            var tf:TextField = new TextField();
            tf.text = sText;
            tf.textColor = uic;
            tf.x = nx;
            tf.y = ny;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.selectable = false;
            var format:TextFormat = new TextFormat();
            format.size = nSiz;
            format.italic = true;
            tf.setTextFormat(format);
            return tf;
        }
    }
}
//package cls {
    //----------------------------------------------
    //ボタンクラス:TextFieldをボタンのように使う
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.ui.MouseCursor;
    import flash.ui.Mouse;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    //public class  clsButton extends TextField {
    class  clsButton extends TextField {
        private var tfFormat:TextFormat;
        private var bolEnable:Boolean;
        private var fncChk:Function;
        
        //ボタンクラス:TextFieldをボタンのように使う
        // sText:表示する文字
        // nX,nY:表示位置
        // nWidth,nHeight:ボタンのサイズ
        // fChk:クリックしたときの関数「fChk(e:MouseEvent):void」
        public function clsButton(sText:String ,
                nX:Number, nY:Number, nWidth:Number, nHeight:Number , fChk:Function) {
            this.text = sText;
            this.x = nX;
            this.y = nY;
            this.width = nWidth;
            this.height = nHeight;
            this.border = true;
            this.borderColor = 0xffffff;
            this.background = true;
            this.backgroundColor = 0x77dd77;
            this.textColor = 0xffffff;
            this.selectable = false;
            tfFormat = new TextFormat();
            tfFormat.align = TextFormatAlign.CENTER;
            tfFormat.size = nHeight *0.8;
            tfFormat.italic = true;
            this.setTextFormat(tfFormat);
            bolEnable = false;
            fncChk = fChk;
            this.enable(true);
        }
        //表示文字の変更
        // sText:表示する文字
        public function setText(sText:String):void {
            this.text = sText;
            this.setTextFormat(tfFormat);
        }
        //ボタンの有効(bflg=true)･無効(bflg=false)
        public function enable(bflg:Boolean):void {
            if (bflg == bolEnable) { return; }
            bolEnable = bflg;
            if (bolEnable) {
                this.addEventListener(MouseEvent.CLICK, fncChk);
                this.addEventListener(MouseEvent.ROLL_OVER, fncOver);
                this.addEventListener(MouseEvent.ROLL_OUT, fncOut);
                this.alpha = 1.0;
            }else {
                this.removeEventListener(MouseEvent.CLICK, fncChk);
                this.removeEventListener(MouseEvent.ROLL_OVER, fncOver);
                this.removeEventListener(MouseEvent.ROLL_OUT, fncOut);
                this.alpha = 0.5;
            }
        }
        //マウスオーバー処理（ボタンらしく見せる）
        public function fncOver(e:MouseEvent):void {
            e.target.backgroundColor = 0x55bb55;
            //Mouse.cursor=flash.ui.MouseCursor.HAND;
        }
        public function fncOut(e:MouseEvent):void {
            e.target.backgroundColor = 0x77dd77;
            //Mouse.cursor=flash.ui.MouseCursor.ARROW;
        }
    }
//}
//package cls {
    //----------------------------------------------
    //デジタル数字クラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;

    //public class clsLedNum extends Sprite {
    class clsLedNum extends Sprite {
        //デジタル数字形状（7形状*6点）
        private const arrPoint1:Array = [
            [7,0],[20,0],[23,3],[20,6],[7,6],[4,3],
            [21,7],[21,20],[24,23],[27,20],[27,7],[24,4],
            [21,28],[21,41],[24,44],[27,41],[27,28],[24,25],
            [7,42],[20,42],[23,45],[20,48],[7,48],[4,45],
            [0,28],[0,41],[3,44],[6,41],[6,28],[3,25],
            [0,7],[0,20],[3,23],[6,20],[6,7],[3,4],
            [7,21],[20,21],[23,24],[20,27],[7,27],[4,24]
        ];
        //数字（文字）に対する形状の表示ON(=1)・OFF(=0)
        // 16進対応
        private const arrFlg:Array = [
            {code:"",flg:[0,0,0,0,0,0,0]},
            {code:"-",flg:[0,0,0,0,0,0,1]},
            {code:"0",flg:[1,1,1,1,1,1,0]},
            {code:"1",flg:[0,1,1,0,0,0,0]},
            {code:"2",flg:[1,1,0,1,1,0,1]},
            {code:"3",flg:[1,1,1,1,0,0,1]},
            {code:"4",flg:[0,1,1,0,0,1,1]},
            {code:"5",flg:[1,0,1,1,0,1,1]},
            {code:"6",flg:[1,0,1,1,1,1,1]},
            {code:"7",flg:[1,1,1,0,0,0,0]},
            {code:"8",flg:[1,1,1,1,1,1,1]},
            {code:"9",flg:[1,1,1,1,0,1,1]},
            {code:"A",flg:[1,1,1,0,1,1,1]},
            {code:"B",flg:[0,0,1,1,1,1,1]},
            {code:"C",flg:[1,0,0,1,1,1,0]},
            {code:"D",flg:[0,1,1,1,1,0,1]},
            {code:"E",flg:[1,0,0,1,1,1,1]},
            {code:"F",flg:[1,0,0,0,1,1,1]},
        ];
        private const numD0:Number = 25.0;
        private var numDD:Number;    //数字幅
        private var numAng:Number;    //数字の傾き
        private var strCod:String;    //表示中の数字（文字）
        //デジタル数字
        // sCod:数字（文字）"","-","0"-"9","A"-"F"
        // nX,nY:位置
        // nSiz:数字幅
        // nAng:数字の傾き
        public function clsLedNum(sCod:String , nX:Number, nY:Number, 
                    nSiz:Number = 25.0, nAng:Number = 10 ) {
            strCod = sCod.toUpperCase();
            numDD = nSiz/numD0;
            numAng = nAng * Math.PI / 180;
            this.x = nX;
            this.y = nY;
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            DispNum();
        }
        //表示数字（文字）の変更
        // sCod:数字（文字）
        public function setVal(sCod:String):void {
            if (strCod == sCod.toUpperCase()) { return; }
            strCod = sCod.toUpperCase();
            DispNum();
        }
        //数字（文字）の表示
        private function DispNum():void {
            graphics.clear();
            var no:int = 0;    //対象外は””と同じ扱いにする
            var i:int;
            for (i = 0; i < arrFlg.length; i++) {
                if (arrFlg[i].code == strCod) {no = i; }
            }
            for (i = 0; i < 7; i++) {
                var ic:uint = 0x00ff00;    //表示ONのとき
                var ar:Number =1.0;
                if (arrFlg[no].flg[i] == 0) {    //表示OFFの時
                    ic = 0x888888;
                    ar = 0.2;
                }
                dispSeg(i, ic,ar);
            }
        }
        //1形状の表示
        // no:形状のNO
        // ic:カラー
        // ar:alpha値
        private function dispSeg(no:int,ic:uint,ar:Number):void {
            var i:int;
            var dx:Number;
            graphics.lineStyle(1, ic,0);
            graphics.beginFill(ic,ar);
            dx = (48 - arrPoint1[no * 6 ][1]) * numAng;
            graphics.moveTo((arrPoint1[no*6][0]+dx)*numDD, (arrPoint1[no*6][1])*numDD);
            for (i = 1; i < 6; i++) {
                dx = (48 - arrPoint1[no * 6 + i][1]) * numAng;
                graphics.lineTo((arrPoint1[no*6+i][0]+dx)*numDD, (arrPoint1[no*6+i][1])*numDD);
            }
            graphics.endFill();
        }
    }
//}
//package cls {
    //----------------------------------------------
    //デジタル数字の区切り（":"）クラス
    // http://programmingatelier.net/
    //----------------------------------------------
    import flash.display.Sprite;
    import flash.events.Event;

    //public class clsLedKugiri extends Sprite {
    class clsLedKugiri extends Sprite {
        //デジタル数字形状（2形状*4点）
        private var arrPoint1:Array = [
            [0,30],[5,30],[5,35],[0,35],
            [0,20],[5,20],[5,15],[0,15]
        ];
        //文字に対する形状の表示ON(=1)・OFF(=0)
        private var arrFlg:Array = [
            {code:"",flg:[0,0]},
            {code:":",flg:[1,1]}
        ];
        private var numD0:Number = 25.0;
        private var numDD:Number;    //数字幅
        private var numAng:Number;    //数字の傾き
        private var strCod:String;    //表示中の数字（文字）
        //デジタル数字の区切り
        // sCod:文字":",""
        // nX,nY:位置
        // nSiz:数字幅
        // nAng:数字の傾き
        public function clsLedKugiri(sCod:String ,
            nX:Number, nY:Number, nSiz:Number = 25.0, nAng:Number = 10 ) {
            strCod = sCod.toUpperCase();
            numDD = nSiz/numD0;
            numAng = nAng * Math.PI / 180;
            this.x = nX;
            this.y = nY;
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            DispKugiri();
        }
        //文字の変更
        // sCod:数字の区切り
        public function setVal(sCod:String):void {
            strCod = sCod.toUpperCase();
            DispKugiri();
        }
        //数字（文字）の表示
        private function DispKugiri():void {
            graphics.clear();
            var no:int = 0;    //対象外は””と同じ扱いにする
            var i:int;
            for (i = 0; i < arrFlg.length; i++) {
                if (arrFlg[i].code == strCod) {no = i; }
            }
            for (i = 0; i < 2; i++) {
                var ic:uint = 0x00ff00;    //表示ONのとき
                var ar:Number =1.0;
                if (arrFlg[no].flg[i] == 0) {    //表示OFFの時
                    ic = 0x888888;
                    ar = 0.2;
                }
                dispSeg(i, ic,ar);
            }
        }
        //1形状の表示
        // no:形状のNO
        // ic:カラー
        // ar:alpha値
        private function dispSeg(no:int,ic:uint,ar:Number):void {
            var i:int;
            var dx:Number;
            
            graphics.lineStyle(1, ic,0);
            graphics.beginFill(ic,ar);
            dx = (48 - arrPoint1[no * 4 ][1]) * numAng;
            graphics.moveTo((arrPoint1[no*4][0]+dx)*numDD, (arrPoint1[no*4][1])*numDD);
            for (i = 1; i < 4; i++) {
                dx = (48 - arrPoint1[no * 4 + i][1]) * numAng;
                graphics.lineTo((arrPoint1[no*4+i][0]+dx)*numDD, (arrPoint1[no*4+i][1])*numDD);
            }
            graphics.endFill();
        }
    }
//}