/**
 * Copyright yuuinaka ( http://wonderfl.net/user/yuuinaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6dzt
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    
    import flash.utils.*;
    
    /*
        TV no ZAAA
        Now Coding...
    */
    
    public class Professional extends Sprite {
        
        public var cnt:Number = 0;
        
        public var dotPatternArray:Array = [[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]];
        
        /*
        public var dotPatternArray:Array = [[0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1],
        [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1],
        [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1],
        [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1],
        [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1],
        [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1],
        [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1],
        [0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1],
        [1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0],
        [1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0],
        [1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0],
        [1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0],
        [1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0],
        [1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0],
        [1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0],
        [1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0]];
        */
        
        public var dotColorsArray:Array = [0xffaaaaaa,0xffcccccc,0xff999999,0xff666666,0xff333333,0xff000000];
        
        public function Professional() {
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var zaaaaID:uint = setInterval(function():void {
                if ((cnt%2) == 0) {
                    dotMove();
                }
                dotLine();
                dotDraw();
                cnt++;
            },33);
            
        }
        
        public function dotDraw():void {
            
            //generate bitmap pattern.
            var pattern:BitmapData = sample1();
            
            var g:Graphics = graphics;
            g.beginBitmapFill(pattern);
            g.drawRect(0,0,480,480);
            g.endFill();
        
        }
        
        public function dotMove():void {
            for (var i = 0; i < dotPatternArray.length; i++) {
                for (var j = 0; j < dotPatternArray[i].length; j++) {
                    if (dotPatternArray[i][j] != 0) {
                        dotPatternArray[i][j] = Math.floor(Math.random() * 5)+1;
                    }
                }    
            }    
        }
        
        public function dotLine():void {
            dotPatternArray.push(dotPatternArray.shift());
            for (var i = 0; i < dotPatternArray.length; i++) {
                dotPatternArray[i].push(dotPatternArray[i].shift());    
            }
        }
        
        //most simple patern
        public function sample1():BitmapData{
            return BitmapPatternBuilder.build(
                dotPatternArray,
                dotColorsArray
            );
        }
    
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}