/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6dyU
 */

package {
    import flash.display.Sprite;
    import flash.display.Shader;
    import flash.display.ShaderJob;
    import flash.text.TextField;
    import flash.utils.getTimer;
    
    //　フレーム数の場合はceilして使うべし
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var myxx : Number = Math.random() * 465;
            var myxy : Number = Math.random() * 465;
            var myvx : Number = Math.random() * 8 - 4;
            var myvy : Number = Math.random() * 8 - 4;
            var myr : Number = 5.0;
            
            // 2500発もあれば十分だろう
            var W : int = 50;
            var H : int = 50;
            var N : int = W * H;
            var bxv : Vector.<Number> = new Vector.<Number>();
            var br : Vector.<Number> = new Vector.<Number>();
            for(var i : int = 0;i < N;i++){
                bxv.push(
                    Math.random() * 465,
                    Math.random() * 465,
                    Math.random() * 8 - 4,
                    Math.random() * 8 - 4
                    );
                br.push(Math.random() * 5 + 5);
            }
            
            var shader : Shader = new CollisionShader();
            shader.data.xv.input = bxv;
            shader.data.xv.width = W;
            shader.data.xv.height = H;
            shader.data.r.input = br;
            shader.data.r.width = W;
            shader.data.r.height = H;
            shader.data.myx.value = [myxx, myxy];
            shader.data.myv.value = [myvx, myvy];
            shader.data.myr.value = [myr];
            
            var res : Vector.<Number> = new Vector.<Number>();
            var S : int = getTimer();
            for(var k : int = 0;k < 1000;k++){
                var sj : ShaderJob = new ShaderJob(shader, res, W, H);
                sj.start(true);
            }
            var G : int = getTimer();
            
            var tf : TextField = new TextField();
            addChild(tf);
            tf.width = 465;
            tf.height = 465;
            tf.text = "" + (G - S) + "/1000 ms";
            /*
            for(i = 0;i < N;i++){
                if(res[4*i] < 9999)tf.appendText("\n" + res[4*i]);
            }
            */
        }
    }
}

class Bullet
{
    public var xx : Number;
    public var xy : Number;
    public var vx : Number;
    public var vy : Number;
    public var r : Number;
}

import flash.display.Shader;
import flash.utils.ByteArray;
class CollisionShader extends Shader
{

	private var vec:Vector.<int> = Vector.<int>( [ 117,82,203,106,219,80,20,156,123,117,35,181,96,168,210,69,54,169,64,5,83,242,218,216,77,178,8,133,170,4,186,109,87,221,22,215,82,193,32,91,65,146,69,188,187,165,63,146,87,247,254,132,248,147,74,126,160,115,174,228,212,41,212,155,185,51,103,206,156,163,131,127,41,0,119,207,113,94,228,249,164,154,20,179,171,222,108,52,205,170,139,209,56,3,174,122,77,54,75,139,146,175,103,77,86,74,29,138,106,154,85,227,114,114,81,11,223,171,143,226,60,155,237,141,243,162,202,170,122,191,101,101,195,199,116,81,30,126,43,247,113,173,52,208,251,250,105,94,159,23,69,153,226,22,230,178,193,173,82,37,174,181,81,120,145,86,117,107,242,166,139,75,220,232,52,251,62,154,231,245,151,81,62,231,22,221,143,6,141,222,116,209,252,223,192,8,205,161,184,81,79,12,239,45,16,121,88,1,33,6,6,191,61,98,180,133,7,131,93,12,52,182,201,21,235,177,198,61,34,131,213,22,235,218,136,127,41,156,45,97,167,47,157,174,133,251,88,57,157,196,131,5,71,135,154,200,156,80,114,250,204,245,219,62,43,124,40,77,252,13,13,146,179,159,47,139,3,234,124,34,82,214,178,13,199,172,41,98,223,224,131,225,28,214,19,79,246,81,54,145,186,244,185,126,31,241,199,87,239,240,150,225,82,18,217,151,185,124,248,244,159,116,199,232,251,120,237,114,232,223,204,105,231,36,143,121,107,63,191,103,32,254,55,68,217,123,232,183,251,106,162,228,27,230,24,114,143,40,115,200,195,142,135,155,243,219,156,207,162,187,156,40,144,59,45,161,136,190,220,147,122,64,189,31,224,135,227,188,75,192,156,67,119,71,183,103,252,119,79,43,253,86,116,175,67,242,68,183,220,33,121,44,253,218,97,130,29,250,2,217,151,196,237,71,116,117,35,200,239,150,162,204,11,30,239,31,186,251,146,187,187,210,164,236,189,187,171,244,69,93,223,250,78,114,55,241,157,118,252,95,140,214,185,27,251,153,86,239,190,15,15,1,255,119,127,0 ] );
	private var byteArr:ByteArray;
	public function CollisionShader():void
	{
		var len:int = vec.length;
		if(!byteArr)
		{
			byteArr = new ByteArray();
			for(var i:int=0; i<len; i++)
			{
				byteArr.writeByte( vec[i] );
			}
			byteArr.inflate();
			this.byteCode = byteArr;
		}
	}

/*
<languageVersion : 1.0;>

kernel Collision
<   namespace : "";
    vendor : "";
    version : 1;
    description : "(t, len(closest), len(rv), myr+br)";
>
{
    input image4 xv;
    input image1 r;
    output pixel4 dst;
    parameter float2 myx
    <
        defaultValue : float2(0.0, 0.0);
    >;
    parameter float2 myv
    <
        defaultValue : float2(0.0, 0.0);
    >;
    parameter float myr
    <
        defaultValue : float(1.0);
    >;

    void
    evaluatePixel()
    {
        float2 oc = outCoord();
        pixel4 bxv = sample(xv, oc);
        pixel1 br = sample(r, oc);
        float2 rx = bxv.rg - myx;
        float2 rv = bxv.ba - myv;
        float rr = br + myr;
        float lrv = length(rv);
        
        float t;
        float cl = float(0);
        if(lrv < 0.001){
            t = length(rx) < rr ? float(0) : float(9999);
        }else{
            if(length(rx) < rr){
                t = float(0);
            }else{
                t = -dot(rx, rv) / lrv / lrv;
                float2 closest = rx + t * rv;
                cl = length(closest);
                if(cl <= rr){
                    t -= sqrt(rr * rr - cl * cl) / lrv;
                    t = t >= float(0) ? t : float(9999);
                }else{
                    t = float(9999);
                }
            }
        }
        
        dst = pixel4(t, cl, lrv, rr);
    }
}
    */
}