/**
 * Copyright kaikoga ( http://wonderfl.net/user/kaikoga )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6drp
 */

// forked from kaikoga's 関数呼び出しは重く、入れ子の関数は更に重い
// forked from tail_y's forked from: [最適化 Tips] Number, int, uint の計算による処理速度の違い
// forked from muta244's [最適化 Tips] Number, int, uint の計算による処理速度の違い

package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:int = 2000000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        
        _measure("クラスとして変数呼び出し", function ():void
        {
            var hoge:Hoge = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = hoge.field;
            }
        });
        
        _measure("親クラスとして変数呼び出し", function ():void
        {
            var hoge:HogeBase = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = hoge.field;
            }
        });
        

        _measure("クラスとして親クラスのメソッド呼び出し", function ():void
        {
            var hoge:Hoge = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                hoge.func0();
            }
        });
        
        _measure("クラスとしてメソッド呼び出し", function ():void
        {
            var hoge:Hoge = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                hoge.func1();
            }
        });
        
        _measure("クラスとしてsuper()入りのメソッド呼び出し", function ():void
        {
            var hoge:Hoge = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                hoge.func2();
            }
        });
        
        _measure("クラスとしてgetter関数呼び出し", function ():void
        {
            var hoge:Hoge = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = hoge.getter;
            }
        });
        
        _measure("親クラスとして親クラスのメソッド呼び出し", function ():void
        {
            var hoge:HogeBase = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                hoge.func0();
            }
        });
        
        _measure("親クラスとしてメソッド呼び出し", function ():void
        {
            var hoge:HogeBase = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                hoge.func1();
            }
        });
        
        _measure("親クラスとしてsuper()入りのメソッド呼び出し", function ():void
        {
            var hoge:HogeBase = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                hoge.func2();
            }
        });
        
        _measure("親クラスとしてgetter関数呼び出し", function ():void
        {
            var hoge:HogeBase = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = hoge.getter;
            }
        });
        
        _measure("インタフェースとして親クラスのメソッド呼び出し", function ():void
        {
            var hoge:IHoge = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                hoge.func0();
            }
        });
        
        _measure("インタフェースとしてメソッド呼び出し", function ():void
        {
            var hoge:IHoge = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                hoge.func1();
            }
        });
        
        _measure("インタフェースとしてsuper()入りのメソッド呼び出し", function ():void
        {
            var hoge:IHoge = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                hoge.func2();
            }
        });
        
        _measure("インタフェースとしてgetter関数呼び出し", function ():void
        {
            var hoge:IHoge = new Hoge();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var o:int = hoge.getter;
            }
        });
        
        
        _debug("\n結論：特に変化なし");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(this, params);
        _time = getTimer() - _time;

        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}

interface IHoge {
    function get getter():int;
    function func0():void;
    function func1():void;
    function func2():void;
}
class HogeBase implements IHoge {
    
    public var field:int;
    
    public function get getter():int {
        return this.field;
    }    
    
    public function HogeBase() {
        super();
    }    
    
    public function func0():void {
        
    }    
    
    public function func1():void {
        
    }    
    
    public function func2():void {
        
    }    
    
}

class Hoge extends HogeBase {
    
    public var field2:int;
    
    override public function get getter():int {
        return this.field2;
    }    
    
    public function Hoge() {
        super();
    }    
    
    override public function func1():void {
        
    }    
    
    override public function func2():void {
        super.func2();
    }    
    
}