/**
 * Copyright nabe ( http://wonderfl.net/user/nabe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6dcK
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	
	/**
	 * ...
	 * @author nabe
	 */
	public class Main extends Sprite 
	{
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);

			var m_:Matrix = new Matrix;
			var s_:Sprite = new Sprite;
			var g_:Graphics = s_.graphics;

			var color_:Array = [];
			var ratio_:Array = [];
			const max_:int = 4;
			for (var i_:int = 0; i_ <= max_;  i_++) {
				color_.push(int(0xFF * i_ / max_));
				ratio_.push(0xFF * Math.tan(Math.PI * 0.25 * i_ / max_));
			}

			g_.clear();
			m_.createGradientBox(1000, 300);
			g_.beginGradientFill(GradientType.LINEAR, color_, null, ratio_, m_); 
			g_.drawRect(0, 0, 1000, 300);
			g_.endFill();

			var bar_:BitmapData = new BitmapData(1000, 300, false);
			bar_.draw(s_);

			var vertice_:Vector.<Number> = new Vector.<Number>;
			var uvt_:Vector.<Number> = new Vector.<Number>;
			vertice_.push(0, 0, 0xFF, 0xFF, 0, 0xFF);
			uvt_.push(0.5, 0, 0, 0.999, 1, 1, 0, 1, 1);

			g_.clear();
			g_.beginBitmapFill(bar_);
			g_.drawTriangles(vertice_, null, uvt_);
			g_.endFill();

			var bd_:BitmapData = new BitmapData(0x200, 0x200, true, 0xFF000000);
			m_.createBox(1, 1, 0, 0x100, 0x100);
			bd_.draw(s_, m_, null, BlendMode.ADD);
			m_.createBox(-1, 1, Math.PI * 1.5, 0x100, 0x100);
			bd_.draw(s_, m_, null, BlendMode.ADD);

			s_.filters = [new ColorMatrixFilter([
				0, 0, 1, 0, 0,
				0, 0, 0, 0, 0,
				0, 0, 0, 0, 0,
				0, 0, 0, 1, 0])];
			m_.createBox(1, 1, Math.PI * 0.5, 0x100, 0x100);
			bd_.draw(s_, m_, null, BlendMode.ADD);
			m_.createBox(-1, 1, Math.PI * 1, 0x100, 0x100);
			bd_.draw(s_, m_, null, BlendMode.ADD);

			s_.filters = [new ColorMatrixFilter([
				0, 0, 0, 0, 0,
				0, 0, 1, 0, 0,
				0, 0, 0, 0, 0,
				0, 0, 0, 1, 0])];
			m_.createBox(1, 1, Math.PI * -0.25, 0x100, 0x100);
			bd_.draw(s_, m_, null, BlendMode.ADD);
			m_.createBox(1, 1, Math.PI * 1, 0x100, 0x100);
			bd_.draw(s_, m_, null, BlendMode.ADD);
			m_.createBox(-1, 1, Math.PI * 0.75, 0x100, 0x100);
			bd_.draw(s_, m_, null, BlendMode.ADD);
			m_.createBox(-1, 1, Math.PI * 0, 0x100, 0x100);
			bd_.draw(s_, m_, null, BlendMode.ADD);

			s_.filters = null;

			g_.clear();
			g_.beginFill(0xFF, 1);
			g_.drawRect(-1, -0x100, 0x101, 0x200);
			m_.createBox(1, 1, Math.PI * -0.25, 0x100, 0x100);
			bd_.draw(s_, m_, null, BlendMode.ADD);

			g_.clear();
			g_.beginFill(0xFF0000, 1);
			g_.drawRect(-1, -0x100, 0x101, 0x200);
			m_.createBox(1, 1, Math.PI * 0.25, 0x100, 0x100);
			bd_.draw(s_, m_, null, BlendMode.ADD);

			g_.clear();
			g_.beginFill(0xFF00, 1);
			g_.drawRect( -1, -1, 0x101, 0x101);
			m_.createBox(1, 1, Math.PI * 0.75, 0x100, 0x100);
			bd_.draw(s_, m_, null, BlendMode.ADD);

			g_.clear();
			g_.beginFill(0xFFFFFF, 1);
			g_.drawRect(0, 0, 0x200, 0x200);
			g_.drawCircle(0x100, 0x100, 0x100);
			m_.createBox(1, 1, 0, 0, 0);
			bd_.draw(s_, m_, null, BlendMode.ERASE);

			addChild(new Bitmap(bd_));
		}
		
	}
	
}