/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6cpY
 */

// forked from ProjectNya's LightClock forked from: Human Clock
// forked from Event's Human Clock
package {
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;

    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;

    public class HumanClock extends Sprite {
        private var _sec:int;
        private var _shpSec:Shape;
        private var _shpMin:Shape;
        private var _shpHour:Shape;
        private var _pathCommands:Vector.<int> = Vector.<int>([1,2,2,2,2]);

        private var head:FireNode;
        private var tail:FireNode;
        private var fingerPos:Object;
        private var power:Number;
        private var mousePos:Array = [232, 232];
        private var sound:Sound;
        private const loopNum:int = 3;
        private static var soundPath:String = "http://www.takasumi-nagai.com/soundfiles/sound001.mp3";

        public function HumanClock() {
            Wonderfl.capture_delay(10);
            initView();
            var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
        }
        
        private function initView():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;

            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();

            var spContainer:Sprite = new Sprite;
            var shp:Shape;
            var t:Number;
            var layer:int;
            for (var i:int = 0; i < 2; ++i)
                spContainer.addChild(new Sprite);

            for (i = 0; i < 360; ++i) {
                shp = new Shape;
                shp.graphics.beginFill(0xFFFFFF);
                if (i % 30 == 0) {
                    layer = 1;
                    drawTrapezium(shp.graphics, 2, 16, 4, 0);
                } 
                shp.rotation = i;
                t = Math.PI / 180 * i - Math.PI / 2;
                shp.x = 180 * Math.cos(t); shp.y = 180 * Math.sin(t);
                Sprite(spContainer.getChildAt(layer)).addChild(shp);
            }

            _shpHour = new Shape;
            _shpHour.graphics.beginFill(0xdc143c);
            drawTrapezium(_shpHour.graphics, 6, 90, 10, -5);
            _shpHour.graphics.endFill();

            _shpMin = new Shape;
            _shpMin.graphics.beginFill(0x228b22);
            drawTrapezium(_shpMin.graphics, 5, 130, 8, -5);
            _shpMin.graphics.endFill();

            _shpSec = new Shape;
            _shpSec.graphics.beginFill(0xeb6101);
            drawTrapezium(_shpSec.graphics, 3, 150, 5, -5);
            _shpSec.graphics.endFill();

            spContainer.x = spContainer.y = 465 >> 1;
            addChild(spContainer);
            spContainer =  Sprite(spContainer.addChild(new Sprite));
            spContainer.addChild(_shpHour);
            spContainer.addChild(_shpMin);
            spContainer.addChild(_shpSec);
            spContainer.rotation = 180;

            onTimer(null);

            sound = new Sound();
            sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
            sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
        }

        private function drawTrapezium($graphics:Graphics, $right:Number, $top:Number, $left:Number, $bottom:Number):void {
            $graphics.drawPath(_pathCommands, Vector.<Number>([
                $left, $bottom, -$left, $bottom, -$right, $top, $right, $top, $left, $bottom
            ]));
        }

        private function onTimer(e:TimerEvent):void {
            var time:Date = new Date;
            var sec:int = time.getSeconds();
            if (_sec == sec) return;

            _sec = sec;
            updateView(time.getHours(), time.getMinutes(), sec);
        }

        private function updateView($hour:int, $min:int, $sec:int):void {
            _shpHour.rotation = ($hour % 12) * 30 + $min / 2;
            _shpMin.rotation = $min * 6;
            _shpSec.rotation = _sec * 6;
        }

        private function complete(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, complete);
            start();
        }

        private function start():void {
            fingerPos = {x: 232, y: 232, vx: 0, vy: 0};
            power = 0;
            var channel:SoundChannel = sound.play(0, 5);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }

        private function update(evt:Event):void {
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, false, 1);
            for (var n:uint = 0; n < 2; n++) {
                for (var t:uint = 0; t < 256; t++) {
                    var rf:Number = bytes.readFloat();
                    if (Math.random() < 0.5) {
                        mousePos[n] = 232 + (0.5 + rf)*116;
                    } else {
                        mousePos[n] = 232 - (0.5 + rf)*116;
                    }
                }
            }
            var fnode:FireNode;
            for(var i:uint = 0; i < loopNum; i++) {
                fingerPos.vx *= 0.75;
                fingerPos.vy *= 0.75;
                fingerPos.vx += (mousePos[0] - fingerPos.x)*0.2*(i+1)/loopNum;
                fingerPos.vy += (mousePos[1] - fingerPos.y)*0.2*(i+1)/loopNum;
                fingerPos.x += fingerPos.vx;
                fingerPos.y += fingerPos.vy;
                power += Math.sqrt(fingerPos.vx*fingerPos.vx + fingerPos.vy*fingerPos.vy)*1.6*i/loopNum;
                power *= 0.85;
                if(power > 100) power = 100;
                fnode = new FireNode(power/4);
                addChild(fnode);
                fnode.x = fingerPos.x - fingerPos.vx*i/loopNum + (Math.random() - 0.5)*30;
                fnode.y = fingerPos.y - fingerPos.vy*i/loopNum + (Math.random() - 0.5)*30;
                fnode.vx = fingerPos.vx*0.3;
                fnode.vy = fingerPos.vy*0.3;
                if (head==null) {
                    head = tail = fnode;
                } else {
                    fnode.prev = tail;
                    tail = tail.next = fnode;
                }
            }
            fnode=head;
            while (fnode!=null) {
                fnode.update();
                if (fnode.isDead) {
                    removeChild(fnode);
                    if (fnode.prev == null) {
                        head = fnode.next;
                    } else {
                        fnode.prev.next = fnode.next;
                    }
                    if (fnode.next == null) {
                        tail = fnode.prev;
                    } else{
                        fnode.next.prev = fnode.prev;
                    }
                }
                fnode = fnode.next;
            }
        }

    }
}


import flash.display.BlendMode;
import flash.display.Sprite;
import flash.filters.BlurFilter;
import frocessing.color.ColorHSV;

class FireNode extends Sprite {
    public var next:FireNode;
    public var prev:FireNode;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var isDead:Boolean = false;
    private static var filetr:BlurFilter=new BlurFilter(16,16);

    public function FireNode(size:Number = 30) {
        var color:ColorHSV = new ColorHSV(Math.random()*360, Math.random()*0.4 + 0.6);
        graphics.beginFill(color.value);
        graphics.drawCircle(0, 0, size);
        blendMode = BlendMode.ADD;
        filters=[filetr];
    }
    
    
    public function update():void {
        if (width < 10) {
            isDead = true;
            return;
        }
        scaleX = scaleY *= 0.95;
        vx *= 0.95;
        vy *= 0.95;
        x += vx;
        y += vy;
    }
}
