/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6c9K
 */

// forked from siouxcitizen's 作業用に公式宇多田ヒカル動画を連続再生
/**
 * Youtube動画を自分作業用に連続再生
 * Dark Tranquillity最新アルバム買ったので昔の曲の復習のため
 * ↑(昔のじゃないのもあるけど)
 * YoutubeのDark Tranquillity動画を連続再生
 * Youtubeの動画IDをベタ書きで配列に設定して連続再生しています
 * 問題ありそうなら削除します
 * ちなみにDark Tranquillityはデスメタルというジャンルの音楽を演奏しているバンドです
 * 
 * 
 */
package {
    
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import com.bit101.components.ComboBox;
    import com.bit101.components.Style;
    import flash.net.URLRequest;
    import flash.net.navigateToURL;

    [SWF(backgroundColor="0x000000", frameRate="30", width="640", height="400")]
    public class Player extends Sprite {
        
        private var _player:Object;
        private var _loader:Loader;
        private var _movieListIndex:int = 0;

        private const _defaultMovieList:Array = [
            ["BolGeBNPK1w", "DARK TRANQUILLITY - Uniformity"], 
            ["QTkwuyb_PLc", "DARK TRANQUILLITY - For Broken Words"], 
            ["NKjzDU7V7es", "DARK TRANQUILLITY - Misery's Crown"], 
            ["CbrtuZNfS4o", "DARK TRANQUILLITY - The Science Of"], 
            ["QLvH0aXmqm8", "DARK TRANQUILLITY - In My Absence"],
            ["5bx-okDZYw4", "DARK TRANQUILLITY - Endtime Hearts"], 
            ["ce4UXfZsrWs", "DARK TRANQUILLITY - Zero Distance"], 
            ["vzVDt1xYFsM", "DARK TRANQUILLITY - Iridium"],
            ["GZqfH1LQEOQ", "DARK TRANQUILLITY - Lost to Apathy"], 
            ["pqRceAh2Jck", "DARK TRANQUILLITY - Therein"], 
            ["vkwWWF1F2m8", "DARK TRANQUILLITY - Focus Shift"], 
            ["3F1W8HJLV5s", "DARK TRANQUILLITY - Monochromatic Stains"],
            ["gkqHj9Q8thw", "DARK TRANQUILLITY - Shadow In Our Blood"]
        ];

        private var _movieList:Array = [
            ["BolGeBNPK1w", "DARK TRANQUILLITY - Uniformity"], 
            ["QTkwuyb_PLc", "DARK TRANQUILLITY - For Broken Words"], 
            ["NKjzDU7V7es", "DARK TRANQUILLITY - Misery's Crown"], 
            ["CbrtuZNfS4o", "DARK TRANQUILLITY - The Science Of"], 
            ["QLvH0aXmqm8", "DARK TRANQUILLITY - In My Absence"],
            ["5bx-okDZYw4", "DARK TRANQUILLITY - Endtime Hearts"], 
            ["ce4UXfZsrWs", "DARK TRANQUILLITY - Zero Distance"], 
            ["vzVDt1xYFsM", "DARK TRANQUILLITY - Iridium"],
            ["GZqfH1LQEOQ", "DARK TRANQUILLITY - Lost to Apathy"], 
            ["pqRceAh2Jck", "DARK TRANQUILLITY - Therein"], 
            ["vkwWWF1F2m8", "DARK TRANQUILLITY - Focus Shift"], 
            ["3F1W8HJLV5s", "DARK TRANQUILLITY - Monochromatic Stains"],
            ["gkqHj9Q8thw", "DARK TRANQUILLITY - Shadow In Our Blood"]
        ];

        private var _previousBtn : CustomButton; //「Previoius」ボタン 前Youtube動画に遷移
        private var _forwardBtn : CustomButton; //「Forward」ボタン 後Youtube動画に遷移
        private var _defaultListBtn : CustomButton; //「Default List」ボタン デフォルトの動画再生リストを設定します
        private var _shuffleListBtn : CustomButton; //「Shuffle List」ボタン ランダムな動画再生リストを設定します
        private var _repeatBtn : CustomButton; // リピート再生機能On Off切り替え
        private var _repeatStateDisp : TextField;// リピー再生するかどうか表示用
        private var _repeatOn : Boolean; // リピート再生するかどうか
        private var _box : ComboBox; // コンボボックス(動画再生リスト)
        private var _amznAffiBtn : CustomButton; //「Amazon」ボタン
        private var _amznSearchKeyword : String = "Dark Tranquillity"; //Amazonで検索を行うためのキーワード
        //↓ここを変更してアマゾンアフィリエイトIDに自分のIDを設定します
        private const AMAZON_AFFILIATE_ID : String = "myinteresting-22"; 

        /// init
        public function Player() {
            _loader = addChild(new Loader()) as Loader;
            _loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit, false, 0, true);
            _loader.x = 40;
            _loader.y = 60;
            _loader.load(new URLRequest("http://www.youtube.com/v/NMNgbISmF4I?version=3")); //Youtubeコントローラー付き 最初はとりあえずののIdを設定
        }
        
        
        /// events
        private function onLoaderInit(event:Event):void {
            _loader.content.addEventListener("onReady", onPlayerReady);
            _loader.content.addEventListener("onError", onPlayerError);
            _loader.content.addEventListener("onStateChange", onPlayerStateChange);
            _loader.content.addEventListener("onPlaybackQualityChange", onVideoPlaybackQualityChange);
        }
        
        private function onPlayerReady(event:Event):void {
            _player = _loader.content;

            //_player.setSize(640, 360);
            //_player.setSize(64, 36);
            //_player.setSize(128, 72);
            //_player.setSize(256, 144);
            //_player.setSize(512, 288);
            _player.setSize(576, 324);
            //_player.setSize(352, 230);

            _previousBtn = new CustomButton("Previous");
            _previousBtn.x = 150;
            _previousBtn.y = 420;
            _previousBtn.addEventListener(MouseEvent.MOUSE_DOWN,onPreviousBtnDown);
            addChild(_previousBtn);

            _forwardBtn = new CustomButton("Foward");
            _forwardBtn.x = 400;
            _forwardBtn.y = 420;
            _forwardBtn.addEventListener(MouseEvent.MOUSE_DOWN,onForwardBtnDown);
            addChild(_forwardBtn);

            _defaultListBtn = new CustomButton("Default List");
            _defaultListBtn.x = 150;
            _defaultListBtn.y = 450;
            _defaultListBtn.addEventListener(MouseEvent.MOUSE_DOWN,onDefaultListBtnDown);
            addChild(_defaultListBtn);

            _shuffleListBtn = new CustomButton("Shuffle List");
            _shuffleListBtn.x = 400;
            _shuffleListBtn.y = 450;
            _shuffleListBtn.addEventListener(MouseEvent.MOUSE_DOWN,onShuffleListBtnDown);
            addChild(_shuffleListBtn);

            _repeatOn = false;

            _repeatBtn = new CustomButton("Repeat");
            _repeatBtn.x = 150;
            _repeatBtn.y = 490;
            _repeatBtn.addEventListener(MouseEvent.MOUSE_DOWN,onRepeatBtnDown);
            addChild(_repeatBtn);

            _repeatStateDisp = new TextField();
            _repeatStateDisp.text = "REPEAT OFF";
            _repeatStateDisp.width = 130;
            _repeatStateDisp.height = 18;
            _repeatStateDisp.x = 400;
            _repeatStateDisp.y = 495;
            _repeatStateDisp.border = true;
            _repeatStateDisp.borderColor = 0xFFFFFF;
            _repeatStateDisp.background = true;
            _repeatStateDisp.backgroundColor = 0x99DDFF;
            _repeatStateDisp.type = TextFieldType.INPUT;
            addChild(_repeatStateDisp);

            //再生動画選択用コンボボックス
            //bit101日本語表示用
            Style.embedFonts = false;
            Style.fontName = "_ゴシック";
            Style.fontSize = 17;

            _box = new ComboBox(this, 30, 0, "Choose an Movie");
            _box.height = 30;
            _box.width = 400;
            _box.numVisibleItems = _defaultMovieList.length

            for (var i:int = 0; i < _defaultMovieList.length; i++) {
                _box.addItem(_defaultMovieList[i][1]);
            }

            _box.addEventListener(Event.SELECT, onSelect);
            addChild(_box);

            //「Amazon」ボタン
            _amznAffiBtn = new CustomButton("Amazon");
            _amznAffiBtn.x = 450;
            _amznAffiBtn.y = 3;
            _amznAffiBtn.addEventListener(MouseEvent.MOUSE_DOWN,onAmznAffiBtnDown);
            addChild(_amznAffiBtn);

            _player.loadVideoById(_movieList[_movieListIndex][0], 0, "default"); //動画リスト最初の動画を再生
        }

        //コンボボックスの内容を動画リストに合わせて更新します
        private function updateComboBoxMovieList():void {
            _box.removeAll();
            _box.numVisibleItems = _defaultMovieList.length
            for (var i:int = 0; i < _defaultMovieList.length; i++) {
                _box.addItem(_movieList[i][1]);
            }
            updateComboBoxIndex();
        }
        //コンボボックスのインデックスを動画リストのインデックスに合わせて更新します
        private function updateComboBoxIndex():void {
           _box.selectedIndex = _movieListIndex;
        }

        private function onSelect(event:Event):void {
            var box:ComboBox = event.currentTarget as ComboBox;
            _movieListIndex = box.selectedIndex;
            _player.loadVideoById(_movieList[_movieListIndex][0], 0, "default"); //コンボボックスで指定された動画を再生
        }

        //指定されたキーワードでアフィリエイト付きでアマゾン検索
        private function onAmznAffiBtnDown(event:MouseEvent):void {
            var amznAffliateUrl : String = "http://www.amazon.co.jp/gp/search?ie=UTF8&keywords="
                                         + _amznSearchKeyword
                                         + "&tag="
                                         + AMAZON_AFFILIATE_ID
                                         + "&index=aps&linkCode=ur2&camp=247&creative=1211";
            navigateToURL(new URLRequest(amznAffliateUrl), '_blank');
        }

        //「Default List」ボタン押下処理 デフォルトの動画再生リストを設定します
        private function onDefaultListBtnDown(event:MouseEvent):void {
            _movieList = _defaultMovieList.slice();
            _movieListIndex = 0;
            _player.loadVideoById(_movieList[_movieListIndex][0], 0, "default");
            updateComboBoxMovieList();
        }

        //「Shuffle List」ボタン押下処理 ランダムな動画再生リストを設定します
        private function onShuffleListBtnDown(event:MouseEvent):void {
            _movieList = shuffle(_defaultMovieList);
            _movieListIndex = 0;
            _player.loadVideoById(_movieList[_movieListIndex][0], 0, "default");
            updateComboBoxMovieList();
        }

        //「Previoius」ボタン押下処理 Youtube動画リストの前動画に遷移
        private function onPreviousBtnDown(event:MouseEvent):void {
            if (_movieListIndex > 0) { //動画リストの最前列でない場合は動画を1つもどしてプレイ開始
                _movieListIndex = _movieListIndex - 1;
            } else if (_movieListIndex == 0) {
                _movieListIndex = _movieList.length - 1 //動画リストが先頭の場合は動画リストの最後尾へ
            } 
            _player.loadVideoById(_movieList[_movieListIndex][0], 0, "default"); //配列インデックスで指定して曲再生
            updateComboBoxIndex();
       }

        //「Forward」ボタン押下処理 Youtube動画リストの次動画に遷移
        private function onForwardBtnDown(event:MouseEvent):void {
            if (_movieList.length - 1 > _movieListIndex) { //動画リストの最後列でない場合は動画を1つすすめてプレイ開始
                _movieListIndex = _movieListIndex + 1;
            } else if (_movieListIndex == _movieList.length - 1) {
                _movieListIndex = 0 //動画リストが最後尾の場合は動画リストの先頭へ
            }
            _player.loadVideoById(_movieList[_movieListIndex][0], 0, "default"); //配列インデックスで指定して曲再生
            updateComboBoxIndex();
        }

        //「Rpeat」ボタン押下処理 Youtube動画リストを繰り返し再生するかどうか設定します
        private function onRepeatBtnDown(event:MouseEvent):void {
            if (_repeatOn) { //動画リストの最後列でない場合は動画を1つすすめてプレイ開始
                _repeatOn = false;
                _repeatStateDisp.text = "REPEAT OFF";
            } else {
                _repeatOn = true;
                _repeatStateDisp.text = "REPEAT ON";
            }
        }

        private function onPlayerError(event:Event):void {
            // Event.data contains the event parameter, which is the error code
        }
        
        private function onPlayerStateChange(event:Event):void {
            // Event.data contains the event parameter, which is the new _player state
            //プレイヤーの状態を判定
            //未開始（-1）、終了（0）、再生中（1）、一時停止中（2）、バッファリング中（3）、頭出し済み（5）

            if (Object(event).data == "0") { //動画が終了した場合
                _movieListIndex++;
                //動画IDリストを超えた場合、かつREPEAT機能有効の場合は動画リストのインデックスを0にもどして再生
                //動画IDリストを超えた場合、かつREPEAT機能無効の場合は動画再生を停止
                if(_movieListIndex > _movieList.length - 1) {
                    //REPEAT機能有効の場合
                    if(_repeatOn) {
                        _movieListIndex = 0; 
                    //REPEAT機能無効の場合
                    } else {
                        return;
                    }
                }
                _player.loadVideoById(_movieList[_movieListIndex][0], 0, "default");
                updateComboBoxIndex();
            }
        }
        
        private function onVideoPlaybackQualityChange(event:Event):void {
            // Event.data contains the event parameter, which is the new video quality
        }
        
        private function shuffle(data:Array):Array {
            var temp:Array = data.slice();
            var dest:Array = new Array();
 
            while (temp.length > 0) {
                var index:int = Math.random() * temp.length;
                dest.push(temp[index]);
                temp.splice(index, 1);
            }
 
            return dest;
        }
    }
    
}

import flash.display.*;
import flash.system.*;
import flash.text.*;
//カスタムボタン
class CustomButton extends SimpleButton {
    private var btnName : String = "";//ボタン名
    private var btnNo : int = 0;//ボタン番号
    //コンストラクタ    
    public function CustomButton(label:String="",no:int=0) {
        btnName = label;
        btnNo = no;
        //状態
        upState = makeSprite(label,0x99DDFF);
        overState = upState;
        downState = makeSprite(label,0x0000FF);
        hitTestState = upState;
    }
    public function getBtnName():String {
        return btnName;
    }
    public function getBtnNo():int {
        return btnNo;
    }
    //ボタン用スプライト作成
    private function makeSprite(text:String,color:uint):Sprite{
        //ボタン用ラベル作成
        var label : TextField = new TextField();
        label.text = text;
        label.autoSize = TextFieldAutoSize.CENTER;
        label.selectable = false;
        label.x = 30;
        label.y = 0;

        //ボタン用スプライト作成
        var sp:Sprite = new Sprite();
        sp.graphics.beginFill(color);
        sp.graphics.drawRoundRect(0, 0, 170, 25, 10);
        sp.graphics.endFill();
        sp.alpha = 0.8;            
        sp.addChild(label);
        //ラベル用フォーマット設定
        var format:TextFormat=new TextFormat();
        format.font = "Courier New";
        format.bold = true;
        format.size = 15;
        label.setTextFormat(format);
        return sp;
    }
}
        