/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6bRA
 */

// forked from Akiyah's forked from: Flex 3 SDKとで三次元を遊ぶ[19]
package
{
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2CircleDef;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Collision.Shapes.b2Shape;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2World;
    import Box2D.Dynamics.Joints.b2MouseJoint;
    import Box2D.Dynamics.Joints.b2MouseJointDef;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.system.Security;
    import org.papervision3d.core.data.UserData;
    import org.papervision3d.core.effects.view.ReflectionView;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.view.BasicView;
    public class Sample extends BasicView 
    {
        public var m_world : b2World;
        public var sd : b2CircleDef;
        public var bd : b2BodyDef;
        public var cube : TriangleMesh3D;
        public var b : b2Body;
        public var RADIUS : Number = 4;
        public var BAR_SIZE : Number = 2;
        Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
        public var path : String = "http://assets.wonderfl.net/images/related_images";
        public var filename : String = path + "/3/35/3590/359061d357d721a573fae94cc4d8b2819a72122c";
        public function Sample() 
        {
            init_box2d();
            init_papervision();
            createBox();
            addEventListener(Event.ENTER_FRAME, update);
        }
        public function update(e : Event) : void
        {
            m_world.Step(1.0 / 30, 10);
            if (b.IsFrozen()) 
            {
                bd.position.Set(0, - 50);
                b = m_world.CreateBody(bd);
                b.CreateShape(sd);
                b.SetMassFromShapes();
            }
            var p : b2Vec2 = b.GetPosition();
            cube.x = - p.x * 10;
            cube.y = - p.y * 10;
            cube.rotationZ = b.GetAngle() * 180 / Math.PI;
            var camera_length : Number = 400;
            var c : Number = (mouseX / stage.width - 0.5) * (Math.PI / 2);
            var d : Number = (mouseY / stage.height) * (Math.PI / 2 / 2);
            camera.x = Math.sin(c) * Math.cos(d) * camera_length;
            camera.z = Math.cos(c) * Math.cos(d) * camera_length;
            camera.y = Math.sin(d) * camera_length;
            singleRender();
        }
        public function init_papervision() : void
        {
            var material : MaterialObject3D = new WireframeMaterial();
            var mlist : MaterialsList = new MaterialsList({all : material});
            var u : Number = BAR_SIZE * 5 * 4;
            var ground : Cube = new Cube(mlist, u * 5, u * 5, u * 5, 5, 5, 5);
            ground.rotationZ = -10;
            scene.addChild(ground);
            viewport.interactive = true;
        }
        public function init_box2d() : void 
        {
            var worldAABB : b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100.0, -100.0);
            worldAABB.upperBound.Set(100.0, 100.0);
            m_world = new b2World(worldAABB, new b2Vec2(0.0, 10.0), true);
            var groundSd : b2PolygonDef = new b2PolygonDef();
            var groundBd : b2BodyDef = new b2BodyDef();
            var groundB : b2Body;
            groundBd.angle = -10 / 180 * Math.PI;
            groundSd.SetAsBox(BAR_SIZE * 5, BAR_SIZE * 5);
            groundB = m_world.CreateBody(groundBd);
            groundB.CreateShape(groundSd);
            groundB.SetMassFromShapes();
            sd = new b2CircleDef();
            bd = new b2BodyDef();
            sd.density = 1.0;
            sd.radius = RADIUS;
        }
        public function createBox() : void 
        {
            var materialTop : BitmapFileMaterial = new BitmapFileMaterial(filename);
            cube = new Cylinder(materialTop, RADIUS * 10, RADIUS * 10 * 4, 8 * 2, 6, -1, true, true);
            cube.rotationX = 90;
            scene.addChild(cube);
            bd.position.Set(0, - 50);
            b = m_world.CreateBody(bd);
            b.CreateShape(sd);
            b.SetMassFromShapes();
        }
    }
}
