/**
 * Copyright asobuno2010 ( http://wonderfl.net/user/asobuno2010 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6bP1
 */

// forked from bikota's flash on 2009-7-20
//-----------------------------------------------------
// title : Ripple
// 波紋効果の練習
//-----------------------------------------------------
//パラメータかえてみる
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.ConvolutionFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext; 
    
    [SWF(backgroundColor="0x000000", frameRate="30")]
    public class AnimationsProject extends Sprite
    {
        
       
        private const IMAGE_URL:String = "http://farm4.static.flickr.com/3598/3519160266_597a6fd570_b.jpg";
        
        private const RIPPLE_SIZE:int = 20; 
        //波紋サイズ：：20→40で四角がめだつ：最初のサイズを決めるものらしい、20に戻した
        
        private const BUFFER_SCALE:Number = 0.1; 
        //バッファ用ビットマップのサイズ：0.2→0.4で波が小さくなった、0.1にした
        //もすこしゆっくり動いてほしいあと波の高さを高く
        
        private var _sample:Bitmap;
        private var _buffer1:BitmapData;
        private var _buffer2:BitmapData;
        private var _defData:BitmapData;
        private var _scale:Number;
        private var _matrix:Matrix; 
        private var _fullRect:Rectangle;
        private var _drawRect:Rectangle;
        private var _origin:Point;
        private var _filter:DisplacementMapFilter;
        private var _convoFilter:ConvolutionFilter;
        private var _colorTransform:ColorTransform;
        
        public function AnimationsProject()
        {
            init();
        }    
        private function init():void
        {
            stage.quality = StageQuality.MEDIUM;
            //BESTを試す：よくわかんないけどときどき止まる
            //HIGHを試す：直線がカクる、不採用で
            //LOWを試す：早いのかもしれないが写真がドット化してる、不採用で
            //MEDIUMを試す：デフォだが、直線カクってる^^;
            //再度BESTを試す：やっぱりカクる。
            //→【結論】不明なので、MEDIUMで。仕上げ時にげんばあわせ。
            
            var req:URLRequest = new URLRequest(IMAGE_URL);
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);    
            loader.load( req, new LoaderContext(true));
        }
        private function loadComplete(e:Event):void
        {    
            e.target.removeEventListener(Event.COMPLETE, loadComplete);
            var sw:int = stage.stageWidth;
            var sh:int = stage.stageHeight;
            
            // 読み込んだ画像を一旦リサイズ
            var source:Bitmap = e.target.loader.content as Bitmap;
            var resizeData:BitmapData = new BitmapData(sw, sh);
            source.width = sw;
            source.height = sh;
            resizeData.draw( source );
            
            _sample = new Bitmap(resizeData);
            addChild(_sample);
            
            // ちょっと傾ける
            rotationX = -30;
            
            
            
            _buffer1 = new BitmapData(_sample.width*BUFFER_SCALE, _sample.height*BUFFER_SCALE, false, 0x000000);
            _buffer2 = new BitmapData(_buffer1.width, _buffer1.height, false, 0x000000);
            _defData = new BitmapData(_sample.width, _sample.height, false, 0x7f7f7f);
            
            _fullRect = new Rectangle(0, 0, _buffer1.width, _buffer1.height);
            _drawRect = new Rectangle();
            

            _filter = new DisplacementMapFilter(_buffer1, new Point(), BitmapDataChannel.BLUE, BitmapDataChannel.BLUE, 80, 80, DisplacementMapFilterMode.WRAP);
            //componentX, componentYを50→100--動きが大きく早くなった？--200,200だと下絵が不明なほど変位--80,80が今のところベスト
            //ConvolutionFilter3-2,4引数を0.8にしたので、100,100にしてみた--やっぱり早くてヤ,80,80に戻す
            //componentX, componentYをともに0にすると、何も動かなくなる
            
            //DisplacementMapFilterMode.WRAP
            //WRAP（デフォ）-動きが繊細な気がする→結局わからないのでデフォで
            //CLAMPを試す--WRAPとの違いがわからないorz
            //IGNOREを試す--気持ち波が高くなったかも--マウス直下の連続反応が減ったかも--動きがおおぶりになった気がする
            //COLORを試す--より水っぽい、粘度の低い動きになった気がする
            //★もっさり動いてほしい★
            
            _sample.filters = [_filter];
        
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        
            //_convoFilter = new ConvolutionFilter(3, 3, [0.5, 1, 0.5, 1, 0, 1, 0.5, 1, 0.5], 3);
            
            _convoFilter = new ConvolutionFilter(3, 3, [0.5, 0.8, 0.5, 0.8, 0, 1, 0.5, 1, 0.5], 3);
            //第4引数 3→5：波紋小さく、一瞬で消える--2：波紋消えない
            
            //第3-1引数 0.5→1：波紋がとまらない
            //第3-3引数 0.5→1：波紋がとまらない
            //第3-2引数 1→0.5：波紋がすぐ終わる
            //第3-4引数 1→0.5：波紋が小さくてすぐ終わる、画面左へはのびる
            //第3-5引数 0→0.5：波紋がとまらない
            //第3-7引数 0.5→1：波紋がとまらない
            //★ぼよんとした動きにするため、第3-2,4引数 1→0.8にした
                       
            _colorTransform = new ColorTransform(1, 1, 1, 1, 0, 128, 128);       
            _matrix = new Matrix(_defData.width/_buffer1.width, 0, 0, _defData.height/_buffer1.height);
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseHandler);
        }
        private function mouseHandler(e:MouseEvent):void
        {
            var rad:int = RIPPLE_SIZE/2 * -1;
            _drawRect.x = ( rad + _sample.mouseX ) * BUFFER_SCALE;    
            _drawRect.y = ( rad + _sample.mouseY ) * BUFFER_SCALE;
            _drawRect.width = _drawRect.height = RIPPLE_SIZE * BUFFER_SCALE;
            _buffer1.fillRect(_drawRect, 0xFF);
            //0xFFを0xFF0000, 0x00では動かなかった
        }
        private function enterFrameHandler(event : Event) : void
        {
            var temp:BitmapData = _buffer2.clone();
            _buffer2.applyFilter(_buffer1, _fullRect, new Point(), _convoFilter);
            _buffer2.draw(temp, null, null, BlendMode.SUBTRACT, null, false);
            _defData.draw(_buffer2, _matrix, _colorTransform, null, null, true);
            _filter.mapBitmap = _defData;
            _sample.filters = [_filter];
            temp.dispose();
            switchBuffers();
        }
        // バッファの入れ替え
        private function switchBuffers():void
        {
            var temp : BitmapData;
            temp = _buffer1;
            _buffer1 = _buffer2;
            _buffer2 = temp;
        }
    }
}