/**
 * Copyright christian ( http://wonderfl.net/user/christian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6ahd
 */

package
{
    import flash.geom.*;
    import flash.display.*;
    import flash.events.Event;

    import com.bit101.components.Style;
    import com.bit101.components.ComboBox;
    
    /*  @author SPANVEGA // CHRISTIAN  */

    public class TWEENS extends Sprite
    {
        private var w : uint = 465, h : uint = 465,

                    s : Bresenham = new Bresenham (w, h, true, 0x0),

                    o : Number = h / 1.5, // y axis origin

                    a : ColorTransform = new ColorTransform (1.0, 1.0, 1.0, 0.98);

        private var b : Number = 0,
                    c : Number = 1,

                    index : int = 0,
                    steps : int = 93,
                    scale : int = h * 0.45,

                    tween : Class = Back,
                    ease : String = 'easeIn';

        private var circ : BitmapData, size : int = 4,

                    line_pt : Point = new Point (0, o),
                    circ_pt : Point = new Point (0, o - scale - size);


        public function TWEENS ()
        {
            var shape : Shape = new Shape ();
            shape.graphics.beginFill (0xFF0080, 1);
            shape.graphics.drawCircle (size, size, size);

            circ = new BitmapData (shape.width, shape.height, true, 0);
            circ.draw (shape);

            with (stage) { scaleMode = 'noScale'; color = 0xFFFFFF; stage.frameRate = 60; }

            with (Style) { BACKGROUND = DROPSHADOW = BUTTON_FACE = 0xFFFFFF; LABEL_TEXT = 0x0; }

            with (new ComboBox (stage, 10, stage.stageHeight - 30, 'Tween',
            [
                {data : Back,        label : 'Back'},
                {data : Bounce,      label : 'Bounce'},
                {data : Circular,    label : 'Circular'},
                {data : Cubic,       label : 'Cubic'},
                {data : Elastic,     label : 'Elastic'},
                {data : Exponential, label : 'Exponential'},
                {data : Linear,      label : 'Linear'},
                {data : Quadratic,   label : 'Quadratic'},
                {data : Quartic,     label : 'Quartic'},
                {data : Quintic,     label : 'Quintic'},
                {data : Sinusoidal,  label : 'Sinusoidal'}
            ]
            ))
            {
                addEventListener (Event.SELECT, select_tween);
                numVisibleItems = items.length;
                openPosition = ComboBox.TOP;
                selectedIndex = 0;
                width = 75;
                draw ();
            }

            with (new ComboBox (stage, 85, stage.stageHeight - 30, 'Ease',
            [
                {data : 'easeIn',    label : 'In'},
                {data : 'easeOut',   label : 'Out'},
                {data : 'easeInOut', label : 'In Out'}
            ]
            ))
            {
                addEventListener (Event.SELECT, select_ease);
                numVisibleItems = items.length;
                openPosition = ComboBox.TOP;
                selectedIndex = 0;
                width = 75;
                draw ();
            }

            graphics.lineStyle (0.5, 0xDEDEDE);

            graphics.moveTo (0, o);
            graphics.lineTo (w, o);

            graphics.moveTo (0, o - scale);
            graphics.lineTo (w, o - scale);

            addChild (new Bitmap (s));

            addEventListener (Event.ENTER_FRAME, render);
        }

        private function select_tween (e : Event) : void
        {
            tween = e.target.selectedItem.data;

            reset (true);
        }

        private function select_ease (e : Event) : void
        {
            ease = e.target.selectedItem.data;

            reset (true);
        }

        private function render (e : Event) : void
        {
            var t : Number = index / steps,

                n : Number = tween [ ease ] (t, b, c - b, 1);

            // tween point on y axis

            s.line (line_pt.x,         line_pt.y,
                    line_pt.x = w * t, line_pt.y = o - (n * scale),
                    0x8000FF);

            // tween shape on x axis

            circ_pt.x = (n * w) - size;

            s.copyPixels (circ, circ.rect, circ_pt, null, null, true);

            if (index == steps)
            {
                reset (false);
            }
            else
            {
                index ++;
            }

            s.colorTransform (s.rect, a);
        }

        private function reset (clear : Boolean) : void
        {
            if (clear) s.fillRect (s.rect, 0);

            index = line_pt.x = 0; line_pt.y = o;
        }
    }
}

/*
============================================================================================
 Easing Equations v2.0
 September 1, 2003
 (c) 2003 Robert Penner, all rights reserved. 
 This work is subject to the terms in http://www.robertpenner.com/easing_terms_of_use.html.
============================================================================================

These tweening functions provide different flavors of 
math-based motion under a consistent API. 

Types of easing:

      Linear
      Quadratic
      Cubic
      Quartic
      Quintic
      Sinusoidal
      Exponential
      Circular
      Elastic
      Back
      Bounce

Changes:
2.0 - ported to ActionScript 2.0; functions now in packages and use strong typing
1.5 - added bounce easing
1.4 - added elastic and back easing
1.3 - tweaked the exponential easing functions to make endpoints exact
1.2 - inline optimizations (changing t and multiplying in one step)--thanks to Tatsuo Kato for the idea
*/

final class Back
{
    public static function easeIn (t : Number, b : Number, c : Number, d : Number, s : Number = 1.70158) : Number
    {
        return c * (t /= d) * t * ((s + 1) * t - s) + b;
    }
    public static function easeOut (t : Number, b : Number, c : Number, d : Number, s : Number = 1.70158) : Number
    {
        return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
    }
    public static function easeInOut (t : Number, b : Number, c : Number, d : Number, s : Number = 1.70158) : Number
    {
        if ((t /= d / 2) < 1) return c / 2 * (t * t * (((s *= (1.525)) + 1) * t - s)) + b;
        return c / 2 * ((t -= 2) * t * (((s *= (1.525)) + 1) * t + s) + 2) + b;
    }
}

final class Bounce
{
    public static function easeOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        if ((t /= d) < (1 / 2.75)) { return c * (7.5625 * t * t) + b; }
        else if (t < (2 / 2.75)) { return c * (7.5625 * (t -= (1.5 / 2.75)) * t + .75) + b; }
        else if (t < (2.5 / 2.75)) { return c * (7.5625 * (t -= (2.25 / 2.75)) * t + .9375) + b; }
        else { return c * (7.5625 * (t -= (2.625 / 2.75)) * t + .984375) + b; }
    }
    public static function easeIn (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c - Bounce.easeOut (d - t, 0, c, d) + b;
    }
    public static function easeInOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        if (t < d / 2) return Bounce.easeIn (t * 2, 0, c, d) * .5 + b;
        else return Bounce.easeOut (t * 2 - d, 0, c, d) * .5 + c * .5 + b;
    }
}

final class Circular
{
    public static function easeIn (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return -c * (Math.sqrt (1 - (t /= d) * t) - 1) + b;
    }
    public static function easeOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * Math.sqrt (1 - (t = t / d - 1) * t) + b;
    }
    public static function easeInOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        if ((t /= d / 2) < 1) return -c / 2 * (Math.sqrt (1 - t * t) - 1) + b;
        return c / 2 * (Math.sqrt (1 - (t -= 2) * t) + 1) + b;
    }
}

final class Cubic
{
    public static function easeIn (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * (t /= d) * t * t + b;
    }
    public static function easeOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * ((t = t / d - 1) * t * t + 1) + b;
    }
    public static function easeInOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        if ((t /= d / 2) < 1) return c / 2 * t * t * t + b;
        return c / 2 * ((t -= 2) * t * t + 2) + b;
    }
}

final class Elastic
{
    public static function easeIn (t : Number, b : Number, c : Number, d : Number, a : Number = 0, p : Number = 0) : Number
    {
        var s : Number;
        if (t == 0) return b;  if ((t /= d) == 1) return b + c;  if (!p) p = d * .3;
        if (!a || a < Math.abs (c)) { a = c; s = p / 4; }
        else s = p / (2 * Math.PI) * Math.asin (c / a);
        return -(a * Math.pow (2, 10 * (t -= 1)) * Math.sin ((t * d - s) * (2 * Math.PI) / p )) + b;
    }
    public static function easeOut (t : Number, b : Number, c : Number, d : Number, a : Number = 0, p : Number = 0) : Number
    {
        var s : Number;
        if (t == 0) return b;  if ((t /= d) == 1) return b + c;  if (!p) p = d * .3;
        if (!a || a < Math.abs (c)) { a = c; s = p / 4; }
        else s = p / (2 * Math.PI) * Math.asin (c / a);
        return (a * Math.pow (2, -10 * t) * Math.sin ((t * d - s) * (2 * Math.PI) / p ) + c + b);
    }
    public static function easeInOut (t : Number, b : Number, c : Number, d : Number, a : Number = 0, p : Number = 0) : Number
    {
        var s : Number;
        if (t == 0) return b;  if ((t /= d / 2) == 2) return b + c;  if (!p) p = d * (.3 * 1.5);
        if (!a || a < Math.abs (c)) { a = c; s = p / 4; }
        else s = p / (2 * Math.PI) * Math.asin (c / a);
        if (t < 1) return -.5 * (a * Math.pow (2, 10 * (t -= 1)) * Math.sin ((t * d - s) * (2 * Math.PI) / p )) + b;
        return a * Math.pow (2, -10 * (t -= 1)) * Math.sin ((t * d - s) * (2 * Math.PI) / p ) * .5 + c + b;
    }
}

final class Exponential
{
    public static function easeIn (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return (t == 0) ? b : c * Math.pow (2, 10 * (t / d - 1)) + b;
    }
    public static function easeOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return (t == d) ? b + c : c * ( -Math.pow (2, -10 * t / d) + 1) + b;
    }
    public static function easeInOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        if (t == 0) return b;
        if (t == d) return b + c;
        if ((t /= d / 2) < 1) return c / 2 * Math.pow (2, 10 * (t - 1)) + b;
        return c / 2 * ( -Math.pow (2, -10 * --t) + 2) + b;
    }
}

final class Linear
{
    public static function easeNone (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * t / d + b;
    }
    public static function easeIn (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * t / d + b;
    }
    public static function easeOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * t / d + b;
    }
    public static function easeInOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * t / d + b;
    }
}

final class Quadratic
{
    public static function easeIn (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * (t /= d) * t + b;
    }
    public static function easeOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return -c * (t /= d) * (t - 2) + b;
    }
    public static function easeInOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        if ((t /= d / 2) < 1) return c / 2 * t * t + b;
        return -c / 2 * ((--t) * (t - 2) - 1) + b;
    }
}

final class Quartic
{
    public static function easeIn (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * (t /= d) * t * t * t + b;
    }
    public static function easeOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return -c * ((t = t / d - 1) * t * t * t - 1) + b;
    }
    public static function easeInOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        if ((t /= d / 2) < 1) return c / 2 * t * t * t * t + b;
        return -c / 2 * ((t -= 2) * t * t * t - 2) + b;
    }
}

final class Quintic
{
    public static function easeIn (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * (t /= d) * t * t * t * t + b;
    }
    public static function easeOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * ((t = t / d - 1) * t * t * t * t + 1) + b;
    }
    public static function easeInOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        if ((t /= d / 2) < 1) return c / 2 * t * t * t * t * t + b;
        return c / 2 * ((t -= 2) * t * t * t * t + 2) + b;
    }
}

final class Sinusoidal
{
    public static function easeIn (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return -c * Math.cos (t / d * (Math.PI / 2)) + c + b;
    }
    public static function easeOut (t : Number, b : Number, c : Number, d : Number) : Number
    {
        return c * Math.sin (t / d * (Math.PI / 2)) + b;
    }
    public static function easeInOut (t :  Number, b : Number, c : Number, d : Number) : Number
    {
        return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b;
    }
}

//

import flash.display.BitmapData;

final class Bresenham extends BitmapData
{
    // http://en.wikipedia.org/wiki/Bresenham's_line_algorithm

    public function Bresenham (width : uint, height : uint, transparent : Boolean = true, color : uint = 0)
    {
        super (width, height, transparent, color);
    }

    public function line (x0 : int, y0 : int, x1 : int, y1 : int, color : uint = 0, alpha : Number = 1) : void
    {
        var step : Boolean = Math.abs (y1 - y0) > Math.abs (x1 - x0);
        var x : int;
        if (step)
        {
            x = x0; x0 = y0; y0 = x;
            x = x1; x1 = y1; y1 = x;
        }
        if (x0 > x1)
        {
            x = x0; x0 = x1; x1 = x;
            x = y0; y0 = y1; y1 = x;
        }
        var dx : int = x1 - x0;
        var dy : int = Math.abs (y1 - y0);
        var e : int = dx * 0.5;
        var ys : int = (y0 < y1) ? 1 : -1;
        var y : int = y0;
        for (x = x0; x <= x1; x++)
        {
            if (step)
            {
                setPixel32 (y, x, alpha * 0xFF << 24 | color);
            } else {
                setPixel32 (x, y, alpha * 0xFF << 24 | color);
            }
            e = e - dy;
            if (e < 0)
            {
                y = y + ys;
                e = e + dx;
            }
        }
    }
}