/**
 * Copyright ifree ( http://wonderfl.net/user/ifree )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6agS
 */

// forked from lizhi's Fruit Ninja2
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BitmapFilter;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import sliz.miniui.Link;
    import sliz.utils.UIUtils;
    
    /**
     * ...
     * @author lizhi http://game-develop.net/
     */
    [SWF(width=465,height=465,backgroundColor=0xffffff,frameRate=25)]
    public class Main extends Sprite
    {
        private var info:TextField;
        private var score:int = 0;
        private var lost:int = 0;
        private var time:int = 0;
        private var particles:Array = [];
        private var rubbishs:Array = [];
        private var lines:Array = [];
        private var cutlayer:Shape = new Shape;
        private var cutBmdLayer:BitmapData;
        private var cutlayerFilter:BitmapFilter;
        private var cutlayerCT:ColorTransform;
        
        
        private var flayer:Shape = new Shape;
        private var fBmdLayer:BitmapData;
        private var flayerFilter:BitmapFilter;
        private var flayerCT:ColorTransform;
        
        private var lastX:Number;
        private var lastY:Number;
        
        public function Main():void
        {
            info = new TextField;
            info.autoSize = TextFieldAutoSize.LEFT;
            info.multiline = true;
            fBmdLayer = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            addChild(new Bitmap(fBmdLayer));
            flayerFilter = new BlurFilter;
            flayerCT = new ColorTransform(1, 1, 1, 0.5);
            
            cutBmdLayer = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            var cutImage:Bitmap = new Bitmap(cutBmdLayer);
            addChild(cutImage);
            addChild(info);
            cutImage.filters = [new GlowFilter( 0xff0000, 1, 16, 16, 2, 3, false, false )];
            cutlayerFilter = new BlurFilter(2,2,3);
            cutlayerCT = new ColorTransform(1, 1, 1, 0);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMD);
            addEventListener(Event.ENTER_FRAME, update);
            
            new Link("more game", "http://game-develop.net", 0, 20, this);
            UIUtils.changeStage(stage);
        }
        
        private function onMD(e:MouseEvent):void
        {
            lastX = mouseX;
            lastY = mouseY;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMM);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMU);
        }
        
        private function onMU(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMM);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMU);
        }
        
        private function onMM(e:MouseEvent):void
        {
            var line:Line = new Line;
            line.x1 = lastX;
            line.y1 = lastY;
            lastX = mouseX;
            lastY = mouseY;
            line.x2 = lastX;
            line.y2 = lastY;
            //if(line.length>50)
            lines.push(line);
        }
        
        private function update(e:Event):void
        {
            var graphics:flash.display.Graphics = flayer.graphics;
            graphics.clear();
       
            cutlayer.graphics.clear();
            for (var i:int = lines.length - 1; i >= 0; i--)
            {
                var line:Line = lines[i];
                
                line.state++;
                if (line.state > 5)
                {
                    lines.splice(i, 1);
                }
                cutlayer.graphics.lineStyle( i / 5  , 0, 1, true, "none", "round", "round", 1);
                cutlayer.graphics.moveTo(line.x1, line.y1);
                cutlayer.graphics.lineTo(line.x2, line.y2);
            }
            cutBmdLayer.colorTransform(cutBmdLayer.rect, cutlayerCT);
            //cutBmdLayer.applyFilter(cutBmdLayer, cutBmdLayer.rect, cutBmdLayer.rect.topLeft, cutlayerFilter);
            cutBmdLayer.draw(cutlayer);
            
            fBmdLayer.colorTransform(fBmdLayer.rect, flayerCT);
            fBmdLayer.applyFilter(fBmdLayer, fBmdLayer.rect, fBmdLayer.rect.topLeft, flayerFilter);
            fBmdLayer.draw(flayer);
            
            info.text = "lost:" + lost + " score:" + score + " time:" + int(time / stage.frameRate);
            time++;
            
        }

        
    }

}
import flash.display.CapsStyle;
import flash.geom.Point;
import flash.display.Graphics;

class Line
{
    public var x1:Number;
    public var y1:Number;
    public var x2:Number;
    public var y2:Number;
    public var state:int = 0;
    public function get length():Number {
        return Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
    }
    public function Line()
    {
    
    }

}

