/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6ad5
 */

/*
  Harmonograph
   http://en.wikipedia.org/wiki/Harmonograph
   http://www.chromeexperiments.com/detail/animated-harmonograph/
*/
package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

	[SWF(width = "480", height = "480", backgroundColor = "0x000000", fps = "30")] 
	public class Practice71 extends Sprite{
		private var A1:Number = 120, f1:Number = 2, p1:Number = 1 / 16, d1:Number = 0.02;
		private var A2:Number = 120, f2:Number = 2, p2:Number = 3 / 2, d2:Number = 0.0315;
		private var A3:Number = 120, f3:Number = 2, p3:Number = 13 / 15, d3:Number = 0.02;
		private var A4:Number = 120, f4:Number = 2, p4:Number = 1, d4:Number = 0.02;
		private var w:Number = 240, h:Number = 240;
		private var deg:int = 0;
		private var run:Boolean = true;
		
		public function Practice71() :void{
			Wonderfl.capture_delay(20);
			addEventListener(Event.ENTER_FRAME,	function(e:Event):void { drawHarmonograph(); } );
			stage.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void { run = !run; } );
		}
		
		private function getColor(i:int, saturation:Number):uint {
			var h:Number = i / 60;
			var ii:Number = Math.floor(h);
			var ff:Number = h - ii;
			var p1:Number = (1.0 - saturation);
			var p2:Number = (1.0 - saturation * ff);
			var p3:Number = (1.0 - saturation * (1.0 - ff));
			var rv:Number, gv:Number, bv:Number;
			switch(ii) {
			case 0:
				rv = 1.0, gv = p3, bv = p1;
				break;
			case 1:
				rv = p2, gv = 1.0, bv = p1;
				break;
			case 2:
				rv = p1, gv = 1.0, bv = p3;
				break;
			case 3:
				rv = p1, gv = p2, bv = 1.0;
				break;
			case 4:
				rv = p3, gv = p1, bv = 1.0;
				break;
			default:
				rv = 1.0, gv = p1, bv = p2;
			}
			var color:uint = (Math.max(0, Math.min(255, rv * 255)) << 16) + (Math.max(0, Math.min(255, gv * 255)) << 8) + Math.max(0, Math.min(255, bv * 255));
			return color;
		}
		
		private function drawHarmonograph():void {
			if (!run) return;
			f1 = (f1 + Math.random() / 40) % 10;
			f2 = (f2 + Math.random() / 40) % 10;
			f3 = (f3 + Math.random() / 40) % 10;
			f4 = (f4 + Math.random() / 40) % 10;
			p1 += 0.05 % (Math.PI * 2);
			deg++;
			graphics.clear();
			graphics.lineStyle(0.1, getColor((deg/2)%360,1.0));
			graphics.moveTo(w, h);
			for (var t:Number= 0; t < 100; t +=0.01) {
				var x:Number = A1 * Math.sin(f1 * t + Math.PI * p1) * Math.exp( -d1 * t) + A2 * Math.sin(f2 * t + Math.PI * p2) * Math.exp( -d2 * t) + w;
				var y:Number = A3 * Math.sin(f3 * t + Math.PI * p3) * Math.exp( -d3 * t) + A4 * Math.sin(f4 * t + Math.PI * p4) * Math.exp( -d4 * t) + h;
				graphics.lineTo(x, y);
			}
		}
	}
}