/**
 * Copyright rickyhk ( http://wonderfl.net/user/rickyhk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Ztl
 */

package {
    import caurina.transitions.Tweener;
   
    import flash.display.Sprite;
   
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
   
    [SWF(width="800", height="600", backgroundColor="#666666", frameRate="31")]
    public class UnfoldingPlane extends BasicView
    {
       
        private var leftPlane:Plane;
        private var basePlane:Plane;
        private var rightPlane:Plane;
        private var backPlane:Plane;
        private var frontPlane:Plane;
        private var topPlane:Plane;
       
        private var redMat:ColorMaterial;
        private var whiteMat:ColorMaterial;
        private var blueMat:ColorMaterial;
        private var greenMat:ColorMaterial;
       
        private var leftPlanePivot:DisplayObject3D;
        private var rightPlanePivot:DisplayObject3D;
        private var backPlanePivot:DisplayObject3D;
        private var frontPlanePivot:DisplayObject3D;
        private var topPlanePivot:DisplayObject3D;
       
        private var container:DisplayObject3D;
       
        public function UnfoldingPlane()
        {
            super(800,600, true, true);
            viewport.buttonMode = true;
            camera.zoom = 10;
            camera.focus = 100;
            camera.useCulling = true;
           
            container = new DisplayObject3D();
           
            redMat = new ColorMaterial(0xff0000, 1, true);
            redMat.doubleSided = true;
            redMat.smooth = true;
            redMat.tiled = true;
           
            whiteMat = new ColorMaterial(0xffffff, 1);
            whiteMat.doubleSided = true;
            whiteMat.smooth = true;
           
            blueMat = new ColorMaterial(0x0000ff, 1, true);
            blueMat.doubleSided = true;
            blueMat.smooth = true;
            blueMat.tiled = true;
           
            greenMat = new ColorMaterial(0x00ff00, 1, true);
            greenMat.doubleSided = true;
            greenMat.smooth = true;
            greenMat.tiled = true;
           
            basePlane = new Plane(new ColorMaterial(0x00000,1), 100, 100, 10, 10);
            leftPlane = new Plane(redMat, 100, 100, 10, 10);
            rightPlane = new Plane(blueMat, 100, 100, 10, 10);
            backPlane = new Plane(whiteMat, 100, 100, 10, 10);
            frontPlane = new Plane(greenMat, 100, 100, 10, 10);
            topPlane = new Plane(blueMat, 100, 100, 10, 10);
           
            leftPlanePivot = new DisplayObject3D();
            rightPlanePivot = new DisplayObject3D();
            backPlanePivot = new DisplayObject3D();
            frontPlanePivot = new DisplayObject3D();
            topPlanePivot = new DisplayObject3D();
           
            leftPlanePivot.addChild(leftPlane);
            rightPlanePivot.addChild(rightPlane);
            backPlanePivot.addChild(backPlane);
            frontPlanePivot.addChild(frontPlane);
            topPlanePivot.addChild(topPlane);
            backPlanePivot.addChild(topPlanePivot);
           
            basePlane.x = 0;
           
            rightPlane.x = 50;
            rightPlanePivot.x = 50;
           
            leftPlane.x = -50;
            leftPlanePivot.x = -50;
           
            backPlane.y = 50;
            backPlanePivot.y = 50;
            backPlanePivot.x = 0;
           
            frontPlane.y = -50;
            frontPlanePivot.y = -50;
            frontPlanePivot.x = 0;
           
            topPlane.y = 50;
            topPlanePivot.y = 100;
            topPlanePivot.x = 0;
           
           
            container.addChild(leftPlanePivot);
            container.addChild(rightPlanePivot);
            container.addChild(backPlanePivot);
            container.addChild(frontPlanePivot);
            //container.addChild(topPlanePivot);
            container.addChild(basePlane);
           
            container.rotationX = 90;
            //container.rotationY = 45;
            container.y = -200;
            scene.addChild(container);
           
            leftPlane.addEventListener(InteractiveScene3DEvent.OBJECT_RELEASE, fold);
            frontPlane.addEventListener(InteractiveScene3DEvent.OBJECT_RELEASE, unfold);
           
            function fold(event:InteractiveScene3DEvent):void
            {
                Tweener.addTween(leftPlanePivot, {rotationY:-90, time:1, transition:"easeInOutSine"});
                Tweener.addTween(backPlanePivot, {rotationX:-90, time:1, delay:0.5, transition:"easeInOutSine"});
                Tweener.addTween(rightPlanePivot, {rotationY:90, time:1, delay:1, transition:"easeInOutSine"});
                Tweener.addTween(frontPlanePivot, {rotationX:90, time:1, delay:1.5, transition:"easeInOutSine", onComplete:rotate});
                Tweener.addTween(topPlanePivot, {rotationX:-90, time:1.5, delay:0.5, transition:"easeInOutSine"});
               
                function rotate():void
                {
                    Tweener.addTween(container, {rotationY:360, time:3});
                }
            }
            function unfold(event:InteractiveScene3DEvent):void
            {
                Tweener.addTween(leftPlanePivot, {rotationY:0, time:1, transition:"easeInOutSine"});
                Tweener.addTween(backPlanePivot, {rotationX:0, time:1, delay:0.5, transition:"easeInOutSine"});
                Tweener.addTween(rightPlanePivot, {rotationY:0, time:1, delay:1, transition:"easeInOutSine"});
                Tweener.addTween(frontPlanePivot, {rotationX:0, time:1, delay:1.5, transition:"easeInOutSine"});
                Tweener.addTween(topPlanePivot, {rotationX:0, time:1.5, delay:0.5, transition:"easeInOutSine"});
            }
           
            startRendering()
        }
    }
}