/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6ZNX
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
    public class FlashTest extends Sprite {
		private var _frame:uint = 0;
		
        public function FlashTest() {
			this.graphics.beginFill(0x000000);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			++_frame;
			if (_frame >= 3) {
				_frame = 0;
				
				var r:uint = 128 + (Math.random() * 128);
				var g:uint = 128 + (Math.random() * 128);
				var b:uint = 128 + (Math.random() * 128);
				var color:uint = (r << 16) + (g << 8) + (b << 0);
				var size:Number = 1.0 + (Math.random() * 3);
				var width:Number = 50 + (Math.random() * 100);
				var hz:uint = 10 + (Math.random() * 30)
				
				var w:Wave = new Wave(color, size, width, hz);
				w.x = 232.5 + ((Math.random() - 0.5) * 200);
				w.y = 232.5 + ((Math.random() - 0.5) * 200);
				w.rotationZ = Math.random() * 360;
				this.addChild(w);
			}
		}
    }
}

import flash.display.Graphics;
import flash.display.Sprite;
import caurina.transitions.Tweener;

class Wave extends Sprite
{
	public function Wave(color:uint, size:Number, width:Number, hz:uint) {
		var frame:uint = 0;
		Tweener.addTween(this,
		{
			alpha:0,
			scaleY:1.5,
			delay:10,
			time:30,
			useFrames:true,
			onUpdate:function():void {
				++frame;
				var g:Graphics = this.graphics;
				g.clear();
				g.lineStyle(size, color);
				var w:Number = 1000;
				var half:Number = w * 0.5;
				var span:Number = w / hz;
				var padding:Number = span * frame / 60 * 4;
				g.moveTo(-half, 0);
				for (var index:uint = 0; index < hz; ++index) {
					g.curveTo(-half + (span * 0.5) + (index * span) + padding, width * ((index % 2 == 0) ? 1:-1), -half + ((index + 1) * span) + padding, 0);
				}
			},
			onComplete:function():void {
				parent.removeChild(this);
			}
		});
	}
}