/**
 * Copyright meat18 ( http://wonderfl.net/user/meat18 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6XfX
 */

package {
	import flash.display.Sprite;
	public class FlashTest extends Sprite {
		public function FlashTest() {
            // write as3 code here..
            stage.frameRate = 60;
            var tc:TimeCircle = new TimeCircle();
            addChild(tc);
            tc.x = 200;
            tc.y = 200;
            tc.center = 60;
        }
    }
}

import flash.display.Sprite;
import flash.events.*;
import flash.text.TextFormat;
import flash.text.TextField;
class TimeCircle extends Sprite{
	public var random:Boolean = false;
	public var colorA:int = 0xFF0000;
	public var colorB:int = 0xFFFFFF;
	public var center:int;
	public var tff:TextFormat = new TextFormat();
	private var tf:TextField = new TextField();
	private var cntTime:int;
	private var colorAry:Array = [];
	private const startAngle:int = 270;
	public function TimeCircle(radius:int = 50,count:Boolean = true){
		var n:Date = new Date();
		cntTime = n.milliseconds;
		center = radius;
		colorAry = [colorA,colorB];
		this.addEventListener(Event.ENTER_FRAME,update);
		tf.autoSize = "left";
		tf.selectable = false;
		tff.size = int(radius*0.8);
		tf.defaultTextFormat = tff;
		if(count){
			this.addChild(tf);
		}
	}
	public function update(e:Event):void{
		var n:Date = new Date();
		if(n.milliseconds < cntTime){
			var newcolor:int = this.random?randomColor():colorAry[0];
			colorAry.push(newcolor);
			colorAry = colorAry.splice(1,2);
		}
		cntTime = n.milliseconds;
		tff.size = int(center*0.8);
		tf.defaultTextFormat = tff;
		tf.text = int(n.milliseconds/100).toString();
		tf.y = -tf.height/2;
		tf.x = -tf.width/2;
		this.graphics.clear();
		this.graphics.beginFill(colorAry[0]);
		this.graphics.drawCircle(0,0,center-0.1);
		this.graphics.beginFill(colorAry[1]);
		this.graphics.moveTo(0,0);
		for(var r:Number = startAngle;r < (360 * (n.milliseconds / 1000)) + startAngle;r += 3){
			var rad:Number = r * Math.PI / 180;
			this.graphics.lineTo(Math.cos(rad) * (center + 0.2),Math.sin(rad) * (center + 0.2));
		}
		rad = ((360 * (n.milliseconds / 1000)) + startAngle) * Math.PI / 180;
		this.graphics.lineTo(Math.cos(rad) * ((center)/2),Math.sin(rad) * ((center)/2));
		this.graphics.beginFill(colorB);
		this.graphics.drawCircle(0,0,center/2);
	}
	public static function randomColor():int{
		var rgb16:String = "";
		for(var i:int = 0;i < 3;i ++){
			var a:String = String(int(Math.floor(Math.random()*256)).toString(16));
			a = a.length == 1?"0" + a:a; 
			rgb16 += a; 
		}
		return int("0x" + rgb16);
	}
}
