/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Wwz
 */

package 
{
	import com.adobe.images.PNGEncoder;
	import com.bit101.components.Label;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.Sprite;
	import flash.external.ExternalInterface;
	import flash.system.Security;
	import flash.text.TextField;
	import flash.utils.ByteArray;
	import flash.utils.setTimeout;
	import mx.utils.Base64Encoder;
	/**
	 * ExternalInterface を使ってJsDoIt と連携。
	 * http://jsdo.it/bkzen/j7qY
	 * @author jc at bk-zen.com
	 */
	[SWF (backgroundColor = "0x000000", width = "465", height = "465", frameRate = "30")]
	public class PerlinNoise extends Sprite
	{
		private var bmp:Bitmap;
		
		public function PerlinNoise() 
		{
			Security.allowDomain("*", "jsdo.it");
			if (stage) init();
			var b: Boolean, str: String = "";
			if (b = ExternalInterface.available)
			{
				try 
				{
					ExternalInterface.addCallback("getNoise", getNoise)
					ExternalInterface.call("asReadyOk");
				}
				catch (err:Error) 
				{
					str =  "" + err;
				}
			}
			var txt: TextField = new TextField();
			txt.text = "v:3 :" + b + ":" + str;
			addChild(txt);
		}
		
		private function getNoise(w: int, h: int):void
		{
			var png: ByteArray = PNGEncoder.encode(makeBmd(w, h));
			var enc: Base64Encoder = new Base64Encoder();
			enc.encodeBytes(png);
			setTimeout(function():void { sendNoise(enc.flush());}, 100);
		}
		
		private function sendNoise(data: String):void
		{
			ExternalInterface.call("receiveNoise", data);
		}
		
		private function init():void
		{
			addChild(bmp = new Bitmap());
			var bmd: BitmapData = makeBmd(stage.stageWidth, stage.stageHeight);
			bmp.bitmapData = bmd;
		}
		
		private function makeBmd(w: int, h: int): BitmapData
		{
			var b: BitmapData = new BitmapData(w, h, false, 0);
			b.perlinNoise(
				w / 2, h / 2, 2, Math.random() * 0xFFFFFF, false, true, BitmapDataChannel.RED | BitmapDataChannel.GREEN
			);
			return b;
		}
	}

}