/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6WbO
 */

/*
画像（JPG,PNG）の書き出し機能を使ったことが無かったので、
試してみた。

参考
http://wonderfl.net/code/ebecbb8758c23fb97b8aceea2a96bef2ed7d80b0
*/

package
{
	import com.bit101.components.CheckBox;
	import com.bit101.components.HSlider;
	import com.bit101.components.Label;
	import com.bit101.components.Panel;
	import com.bit101.components.PushButton;
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	[SWF(backgroundColor="0x777777",width=465,height=465)]
	public class saveImage extends Sprite
	{
		private var _canvas:Sprite = new Sprite();
		private var _hSlider:HSlider;
		private var _is32BitColor:CheckBox;
		private var _isClearEdge:CheckBox;
		private var _isEven:CheckBox;
		private var _jpgLavel:Label;
		public function saveImage()
		{
			_canvas.graphics.beginGradientFill("radial",[0xFF0000,0x0000FF],[1,0],[0,0xFF],new Matrix())
			_canvas.graphics.drawRoundRect(0,0,stage.stageWidth-16,300,32);
			_canvas.graphics.endFill();
			_canvas.graphics.beginFill(0xFF0000,0.5);
			_canvas.graphics.drawCircle(465/4,50,40);
			_canvas.graphics.endFill();
			_canvas.graphics.beginFill(0x00FF00,0.5);
			_canvas.graphics.drawCircle(465/2,50,40);
			_canvas.graphics.endFill();
			_canvas.graphics.beginFill(0x0000FF,0.5);
			_canvas.graphics.drawCircle(465*3/4,50,40);
			_canvas.graphics.endFill();
			_canvas.x = 8;
			_canvas.y = 8;
			
			this.addChild(_canvas);
			var tf:TextField = new TextField();
			tf.defaultTextFormat = new TextFormat(null,36);
			tf.multiline = true;
			tf.wordWrap = true;
			tf.x = 8;
			tf.y = 8;
			tf.text = "下のボタンを押すと、JPGまたはPNG画像を書き出すことができます。";
			tf.width = _canvas.width-16;
			tf.height = _canvas.height-16;
			tf.type = "input";
			tf.border = true;
			_canvas.addChild(tf);
			
			var panelJPG:Panel = new Panel(this,100,320);
			panelJPG.width = 116;
			panelJPG.height = 82;
			_jpgLavel = new Label(panelJPG,8,4,"Quality:90");
			_hSlider = new HSlider(panelJPG,8,8+16,atJPGSlider);
			_hSlider.value = 90;
			new PushButton(panelJPG,8,8+16*3,"SAVE JPG",atJPGClick);
			
			var panelPNG:Panel = new Panel(this,265,320);
			panelPNG.width = 116;
			panelPNG.height = 82;
			_is32BitColor = new CheckBox(panelPNG,8,8,"32 Bit Color");
			_is32BitColor.selected = true;
			_isClearEdge = new CheckBox(panelPNG,8,8+16,"Clear Edge");
			_isEven = new CheckBox(panelPNG,8,8+16*2,"Even");
			new PushButton(panelPNG,8,8+16*3,"SAVE PNG",atPNGClick);
		}
		private function atPNGClick(event:MouseEvent):void{
			SaveImage.PNGfromDisplayObject(_canvas,_is32BitColor.selected,_isClearEdge.selected,_isEven.selected);
		}
		private function atJPGClick(event:MouseEvent):void{
			SaveImage.JPGfromDisplayObject(_canvas,Number(_jpgLavel.text.substr(8)));
		}
		private function atJPGSlider(event:Event):void{
			_jpgLavel.text = String("Quality:"+Math.round(event.target.value));
		}
	}
}
import com.adobe.images.JPGEncoder;
import com.adobe.images.PNGEncoder;

import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.geom.Matrix;
import flash.net.FileReference;
import flash.utils.ByteArray;

class SaveImage{
	public function SaveImage(){};
	/**
	 * PNG画像を書き出すためのメソッド
	 * @param displayObject
	 * @param is32BitColor//アルファチャンネル付きか否か
	 * @param isClearEdge//1pxの余白を付けるか否か
	 * @param isEven//画像の大きさ（縦横）を偶数にするか否か
	 * 
	 */	
	public static function PNGfromDisplayObject(displayObject:DisplayObject,is32BitColor:Boolean = true,isClearEdge:Boolean=false,isEven:Boolean=false):void{
		var width:int = displayObject.width+(isClearEdge?2:0);
		var height:int = displayObject.height+(isClearEdge?2:0);
		var txty:int = isClearEdge?1:0;
		if(isEven){
			width += width%2;
			height += height%2;
		}
		var bitmapData:BitmapData = new BitmapData(width,height,is32BitColor,0xFFFFFF);
		bitmapData.draw(displayObject,new Matrix(1,0,0,1,txty,txty));
		var byteArray:ByteArray = PNGEncoder.encode(bitmapData);
		var fileReference:FileReference = new FileReference();
		fileReference.save(byteArray,"image.png");
	}
	/**
	 * JPG画像を書き出すためのメソッド
	 * @param displayObject
	 * @param quality//画質0-100
	 * 
	 */	
	public static function JPGfromDisplayObject(displayObject:DisplayObject,quality:Number=50):void{
		var width:int = displayObject.width;
		var height:int = displayObject.height;
		var bitmapData:BitmapData = new BitmapData(width,height);
		bitmapData.draw(displayObject);
		var jPGEncoder:JPGEncoder = new JPGEncoder(quality);
		var byteArray:ByteArray = jPGEncoder.encode(bitmapData);
		var fileReference:FileReference = new FileReference();
		fileReference.save(byteArray,"image.jpg");
	}
}