/**
 * Copyright LuisReyes ( http://wonderfl.net/user/LuisReyes )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6W6N
 */

// forked from shapevent's Click to Destroy QB2D
package {
    import flash.display.MovieClip;
    import flash.events.MouseEvent;
    import flash.utils.Dictionary;
    
    public class FlashTest extends MovieClip {
        import com.actionsnippet.qbox.*;
        
        private var sim:QuickBox2D;
        private var lookup:Dictionary = new Dictionary();
        
        public function FlashTest() 
        {
            sim = new QuickBox2D(this,{debug:false,gravityY:-20});
            sim.setDefault({fillColor:0x999999, lineAlpha:1});
            sim.createStageWalls();
            
            //Base is where the balloons will join to
            var base:QuickObject = sim.addBox({x:(stage.stageWidth / 30)/2, y:14.875, width:0.25,height:0.25, density:0});
            
            //Loop and create balloons with joints and assign listeners
            for(var i:int = 0; i < 5; i++)
            {
                //Create balloon
                var balloon:QuickObject = sim.addCircle({x:5+i,y:10,radius:1});
                
                //Create joint for balloon
                var joint:QuickObject = sim.addJoint({a:balloon.body,b:base.body,length:5+i/(i/2)});
                
                //This is what does the trick,
                //so at the time of destoying the object the 
                //balloon links to its joint in the dictionary
                lookup[balloon.userData] = joint;
                 
                //Add mouse event listener for click action
                balloon.userData.addEventListener(MouseEvent.CLICK, onDestroy);
            }
           
           //Begin QuickBox2D Simulation
           sim.start();
            
        }
        
        private function onDestroy(evt:MouseEvent):void{
            //Remove Event Listener
            evt.currentTarget.removeEventListener(MouseEvent.CLICK, onDestroy);
            
            //Destroy linked element using the dictionary reference
            lookup[evt.currentTarget].destroy();
            
        }
    }
}