/**
 * Copyright nemu90kWw ( http://wonderfl.net/user/nemu90kWw )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6W4h
 */


// forked from clockmaker's 重力マウス（100万パーティクル）
// forked from cjcat2266's 重力マウス（プチ軽量化：25万パーティクル）
// forked from clockmaker's 重力マウス（プチ軽量化：10万パーティクル）
// forked from coppieee's 重力マウス（さらに軽量化してみた）
// forked from paq's forked from: 重力マウス（ちょっぴり軽量化してみた）
// forked from fumix's 重力マウス（リンクリストにしてみた）
// forked from undo's 重力マウス
//　リンクリストにしてみたけどそんなに速くない？？
//_bmd.fillRect()を_bmd.setPixel()に変更。
//sin(),cos(),atan2(),sqrt()を排除。
// Add final class / mouseEnalbled = false by clockmaker
// CJ Cat: Used vector instead of linked list.
// clockmaker: while文の処理を4回コピペしてイテレーションの回数を減らす 100万で30fps (FP10.1 Release))
// nemu90kWw: 分割方法を変更してマウス移動時の変なつっかかりを抑える。なぜか画面端処理が無くなっていたのも修正。実は前のやり方のほうが早かったらしいので戻した。
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.geom.Rectangle;
	import flash.utils.Dictionary;
	import net.hires.debug.Stats;

	[SWF(frameRate='60', width='465', height='465', backgroundColor='0x000000')]
	public class Main extends Sprite
	{
		private var _bmp:Bitmap;
		private var _bmd:BitmapData;
		private var _bmdRect:Rectangle;
		private var _colorTransform:ColorTransform = new ColorTransform(0.88, 0.88, 0.97, 1.0, 4, 2, 2, 0);

		private const _maxNum:int = 10000;
		private const _maxPool:int = 10;
		private const _speed:int = 50 * _maxPool;
		private var _cnt:int = 0;
		
		private const _first:Vector.<Node> = new Vector.<Node>(_maxPool, true);

		function Main()
		{
			if(stage) {init(null);}
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(evt:Event):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			this.stage.align = StageAlign.TOP_LEFT;
			this.stage.scaleMode = StageScaleMode.NO_SCALE;
			this.stage.quality = "low";
			this.mouseEnabled = false;
			this.mouseChildren = false;
		
			var old:Node;
			
			_bmd = new BitmapData(465, 465, false, 0x000000);
			_bmp = new Bitmap(_bmd);
			addChild(_bmp);
			this._bmdRect = _bmd.rect;
			
			for(var k:int = 0; k < _maxPool; k++)
			{
				for (var i:int = 0; i < this._maxNum; i++)
				{
					var n:Node = new Node();
					n.pos_x = Math.random() * 465 >> 0;
					n.pos_y = Math.random() * 465 >> 0;
					//リンクリスト
					if (_first[k] == null) {
						old = _first[k] = n;
					} else {
						old.next = n;
						old = n;
					}
				}
			}
			
			addChild(new Stats());
			addEventListener(Event.ENTER_FRAME, onEnter);
		}

		private function onEnter(evt:Event):void
		{
			var gravPoint_x:Number = mouseX;
			var gravPoint_y:Number = mouseY;
			var calc:int = _cnt % _maxPool;
			var bmd:BitmapData = _bmd;
			bmd.lock();
			
			for(var k:int = 0; k < _maxPool; k++)
			{
				var n:Node = this._first[k];
				
				if(calc == k)
				{
					do {
						var diff_x:Number = gravPoint_x - n.pos_x;
						var diff_y:Number = gravPoint_y - n.pos_y;
						var acc:Number = _speed / (diff_x * diff_x + diff_y * diff_y);
						var acc_x:Number = acc * diff_x;
						var acc_y:Number = acc * diff_y;
						n.v_x += acc * diff_x;
						n.v_y += acc * diff_y;
						
						n.pos_x += n.v_x;
						n.pos_y += n.v_y;
						
						n.v_x *= 0.84;
						n.v_y *= 0.84;
						
						if (n.pos_x > 465) {n.pos_x -= 465;}
						else if (n.pos_x < 0) {n.pos_x += 465;}
						if (n.pos_y > 465) {n.pos_y -= 465;}
						else if (n.pos_y < 0) {n.pos_y += 465;}
							
						bmd.setPixel(n.pos_x >> 0, n.pos_y >> 0, 0xffffff); 
					}
					while (n = n.next);
				}
				else {
					do {
						n.pos_x += n.v_x;
						n.pos_y += n.v_y;
						
						bmd.setPixel(n.pos_x >> 0, n.pos_y >> 0, 0xffffff); 
					}
					while (n = n.next);
				}
			}
			bmd.colorTransform(this._bmdRect, this._colorTransform);
			bmd.unlock();
			
			_cnt++;
		}
	}
}

final class Node
{
	public var v_x:Number = 0;
	public var v_y:Number = 0;
	public var pos_x:Number = 0;
	public var pos_y:Number = 0;
	public var next:Node;
}
