/**
 * Copyright ongaeshi ( http://wonderfl.net/user/ongaeshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Vvd
 */

// forked from ongaeshi's [PV3D] 球の移動、斜め移動を可能に
// forked from yes_i_can's [PV3D]キーボードで移動
// forked from yes_i_can's forked from: [PV3D] Simple Sphere
package  
{   
        import flash.events.Event;
        import flash.events.KeyboardEvent;
        import flash.ui.Keyboard;
        
        // 必要なライブラリをインポートします
        import org.papervision3d.materials.ColorMaterial;
        import org.papervision3d.materials.special.CompositeMaterial;
        import org.papervision3d.lights.PointLight3D;
        import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
        import org.papervision3d.materials.WireframeMaterial;
        import org.papervision3d.objects.primitives.Plane;
        import org.papervision3d.objects.primitives.Sphere;
        import org.papervision3d.view.BasicView;
        import org.papervision3d.core.effects.view.ReflectionView;
        
        

         
        public class Main extends ReflectionView {
            private var ball:Sphere;
            private var dx:int = 8;
            private var dz:int = 8;
            
            private var keyUp:Boolean = false;
            private var keyDown:Boolean = false;
            private var keyRight:Boolean = false;
            private var keyLeft:Boolean = false;

            public function Main() {
                stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
                stage.addEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
                stage.addEventListener(Event.DEACTIVATE, deActiveHandler);
                init();
            }
            
            private function init():void {
                //カメラ位置////////////////////////////////////////////////
                camera.y = 200;
                
                //床の作成//////////////////////////////////////////////////
                var wm:WireframeMaterial = new WireframeMaterial();
                var col:ColorMaterial = new ColorMaterial(0xffffff, 0.5);
                var co:CompositeMaterial = new CompositeMaterial();
                co.addMaterial(wm);
                co.addMaterial(col);
                
                var floor:Plane = new Plane(co, 2000, 2000, 12, 12);
                floor.pitch( -90);

                //床を3Dシーンに表示/////////////////////////////////////////
                scene.addChild(floor);

                // 球面を作成///////////////////////////////////////////////
                var material: CompositeMaterial = new CompositeMaterial();
                material.addMaterial(new WireframeMaterial(0xff6633));
                material.addMaterial(new ColorMaterial(0xdcdcdc));
                
                ball = new Sphere(material, 50, 6, 6);
                ball.y = 50;

                // 球面を3Dシーンに表示//////////////////////////////////////
                scene.addChild(ball);
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
            }
            
            private function onEnterFrame(e:Event):void {
                moveSphere();
                updateCamera();
                singleRender();
            }

            private function moveSphere():void {
                if(keyLeft) {
                    ball.x = ball.x + dx;
                }

                if(keyRight) {
                    ball.x = ball.x - dx;
                }

                if(keyUp) {
                    ball.z = ball.z - dz;
                }

                if(keyDown) {
                    ball.z = ball.z + dz;
                }
            }
            
            private function updateCamera():void {
                camera.target = ball;
                camera.x = ball.x;
                camera.y = ball.y + 200;
                camera.z = ball.z + 200;
            }
            
            private function keyDownHandler(event:KeyboardEvent):void {
                if(event.keyCode == Keyboard.LEFT) keyLeft = true;
                if(event.keyCode == Keyboard.RIGHT) keyRight = true;
                if(event.keyCode == Keyboard.UP) keyUp = true;
                if(event.keyCode == Keyboard.DOWN) keyDown = true;
            }

            private function keyUpHandler(event:KeyboardEvent):void {
                if(event.keyCode == Keyboard.LEFT) keyLeft = false;
                if(event.keyCode == Keyboard.RIGHT) keyRight = false;
                if(event.keyCode == Keyboard.UP) keyUp = false;
                if(event.keyCode == Keyboard.DOWN) keyDown = false;
            }

            private function deActiveHandler(event:Event):void {
                keyLeft = false;
                keyRight = false;
                keyUp = false;
                keyDown = false;
            }
        }
}