/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Vnk
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	[SWF(width = "480", height = "480", backgroundColor = "0xffffff", fps = "30")] 
	public class Practice73 extends Sprite{
		private var list:Array;
		private var ws:Number = 10;
		private var isPress:Boolean = false;
		
		public function Practice73() {
			list = new Array();
			for (var i:int = 0; i < 5; i++) {
				for (var ww:int = 0; ww <= 480; ww = ww + ws) {
					var w:WaveBar = new WaveBar();
					w.x = ww; w.w = ws; w.h = 250-50*i; w.bh = 250-50*i;
					list.push(w);
				}
			}
			addEventListener(Event.ENTER_FRAME, update);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void { isPress = true; } );
			stage.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void { isPress = false; } );
		}
		
		private function update(e:Event):void {
			graphics.clear();
			for (var i:int = 0; i < list.length;i++){
				var w:WaveBar = list[i];
				w.draw(graphics);
				if (isPress && w.isContain(mouseX)) w.vh += 30;
				w.vh += (w.bh - w.h) /4;
			}
			list[0].vh *= 0.9;list[list.length-1].vh *= 0.9;
			for (i = 1; i < list.length-1;i++){
				list[i].vh = (list[i - 1].vh + list[i].vh*3.0 + list[i + 1].vh) / 5.0;
			}
			WaveBar.col=(WaveBar.col+0.1)%360;
		}	
	}
}
import flash.display.Graphics;
class WaveBar {
	public static var HEIGHT:Number = 480;
	public var x:Number;
	public var w:Number;
	public var h:Number;
	public var bh:Number;
	public var vh:Number = 0;
	public static var col:Number = 0;
	
	public function draw(g:Graphics):void {
		var color:uint = (255*h/480 << 16) + (255*h/480 << 8) + 255;
		g.beginFill(color);
		g.drawRect(x, HEIGHT - h, 10, h);
		g.endFill();
		h += vh;
	}
	
	public function isContain(px:Number):Boolean {
		return (px > x && px <= x + 10);
	}
}

