/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6V62
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Rectangle;

    [SWF(width = '465', height = '465')]
    /*
     * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     * Chaos Exploration | Hour 02
     * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     * 
     * "Big Mistake. Triggered something in mysterious code. Cannot control,
     * it's after me now, have to find a --*
     *
     * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     */
    public class ChaoXP02 extends Sprite {
        private var bmd : BitmapData;
        private var buff : Vector.<uint>;
        private var seed : int = 2222;
        private var cnt : uint = 2;

        function ChaoXP02() {
            /* */

            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.fullScreenSourceRect = new Rectangle(0, 0, 465, 465);
            stage.quality = StageQuality.LOW;
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            /* */

            var bm : Bitmap = new Bitmap(bmd = new BitmapData(512, 512, false));
            bm.opaqueBackground = 0x0;
            bm.x = bm.y = -(512 - 465) / 2;
            addChild(bm);

            buff = new Vector.<uint>(512 * 512, true);

            /* */

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void {
            this.cnt++;
            this.seed = (((this.seed & 1) - 1) & 0xF00FC7C8) ^ (this.seed >> 1);

            var cnt : int = this.cnt;
            var seed : int = this.seed;
            var cat : Number = 0.0;
            var sat : Number = 0.0;
            var fx : Number = stage.mouseX / 512;
            var fy : Number = 6.283185307179586 * (1 + (stage.mouseY / 256));
            var af : Number = 6.283185307179586 / fy;

            var n : uint = buff.length - 1024;
            while (n-- > 1023) {
                cnt++;
                if ((cnt & 3) != 1) {
                    var c : uint = (buff[n] & 0xFF) >> 1;

                    c += (c >> 1);
                    c += (c >> 1);
                    c += (c >> 1);
                    c += (c >> 2);
                    c += (c >> 2);

                    c = (c >> 1) + (c >> 2);

                    buff[n] = (c << 16) | ((c - (c >> 5)) << 8) | (c - (c >> 3));
                } else {
                    seed = (((seed & 1) - 1) & 0xF00FC7C8) ^ (seed >> 1);
                    seed = (((seed & 1) - 1) & 0xF00FC7C8) ^ (seed >> 1);

                    var ang : Number = (seed & 511) / 512 * fy * 2 * af;
                    cat += (lqcos(ang) - cat) * fx;
                    sat += (lqsin(ang) - sat) * fx;

                    buff[(((cat + 1) * 256) & 511) + ((((sat + 1) * 256) & 511) << 9)] = 0xFFFFFF;
                }
            }

            bmd.setVector(bmd.rect, buff);
        }

        private function lqsin(x : Number) : Number {
            x %= 6.283185307179586;
            if (x > 3.141592653589793) x -= 6.283185307179586;
            if (x < -3.141592653589793) x += 6.283185307179586;
            return (x < 0) ? 1.27323954 * x + 0.405284735 * x * x : 1.27323954 * x - 0.405284735 * x * x;
        }

        private function lqcos(x : Number) : Number {
            return lqsin(x + 1.5707963267948966);
        }
    }
}