/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6UTW
 */

//たまにこういうヒゲが生える。
package {
	import flash.events.Event;
    import flash.display.Sprite;
    import org.papervision3d.view.*;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    public class FlashTest extends BasicView {
    	    private var rot:Number = 0;
        public function FlashTest() {
        	    //下の平面。これがないと何がなんだかわからない
        	    var p:Plane = new Plane(new WireframeMaterial(0xFFCC00), 500, 500, 20, 20);
        	    p.rotationX = 90;
        	    
        	    ///ベジェ曲線を描く
            var lm:LineMaterial = new LineMaterial(0x000000);//ラインマテリアル。lineStyleみたいな感じ？
            var lines:Lines3D = new Lines3D(lm);
            var v1:Vertex3D = new Vertex3D(0, 0, 0);//始点
            var v2:Vertex3D = new Vertex3D(100, 100, 100);//終点
            var line:Line3D = new Line3D(lines, lm, 3, v1, v2);
            
            //コントロールポイント
            var cv:Vertex3D = new Vertex3D(0, 200, 0);
            line.addControlVertex(cv.x, cv.y, cv.z);
            
            //Lines3DにLine3Dを追加
            lines.addLine(line);
            
            //シーンに追加
            scene.addChild(p);
            scene.addChild(lines);
            
            camera.y = 500;
            camera.zoom = 80;
            
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
        	    //カメラの制御(『Flash 3Dコンテンツ制作のためのPapervision3D入門』より引用)
        	    var targetRot:Number = ( mouseX / stage.stageWidth ) * 360;
        	    rot += ( targetRot - rot ) * 0.02;
        	    camera.x = 1000 * Math.sin(rot * Math.PI / 180);
        	    camera.z = 1000 * Math.cos(rot * Math.PI / 180);
        	    
        	    
        }
    }
}