/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6UOy
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.TriangleCulling;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Rectangle;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    
    [SWF(width = "465", height = "465", backgroundColor="0x666666")]
    
    public class WebSafeColor extends Sprite
    {
        private var cube:Vector.<Number>;
        private var vertices:Vector.<Number>;
        private var indices:Vector.<int>;
        private var sortedIndices:Vector.<int>;
        private var uvts:Vector.<Number>;
        private var pv:Vector.<Number>;
        private var transVertex:Vector.<Number>;
        
        private var faces:Array;
        private var cubes:Vector.<Cube>;
        
        private var proj:PerspectiveProjection;
        private var m:Matrix3D;
        private var bd:BitmapData;
        
        private var flg:Boolean = false;
        private var g:Graphics;
        private var translate:Number;
        
        private var hlsHeight:int = 200;
        private var mode:Boolean = false;
        
        public function WebSafeColor()
        {
            create();
            //addChild( new Bitmap( bd ) );
            
            m = new Matrix3D();
            proj = new PerspectiveProjection();
            
            var s:Shape = addChild( new Shape() ) as Shape;
            s.x = s.y = 465 >> 1;
            g = s.graphics;
            
            graphics.lineStyle( 1 );
            graphics.moveTo( 232.5, 0);
            graphics.lineTo( 232.5, 465);
            graphics.moveTo(0, 232.5 );
            graphics.lineTo( 465, 232.5 );
            
            render();
            addEventListener(Event.ENTER_FRAME, onEnter);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        private function onClick( e:MouseEvent ):void
        {
            if( mode == false )
            {
                mode = true;
                setHLS();
            }else
            {
                mode = false;
                setRGB();
            }
        }
        private function onEnter( e:Event ):void
        {
            render();
        }
        
        private function setRGB():void
        {
            var count:int = 0;
            var margin:int = 20;
            translate = (-6 * margin + margin) >> 1;
            for( var b:int = 0; b<6; b++ )
            {
                for( var g:int = 0; g<6; g++ )
                {
                    for( var r:int = 0; r<6; r++ ){
                        var cube:Cube = cubes[count++] as Cube;
                        cube.x = r * margin + translate;
                        cube.y = g * margin + translate;
                        cube.z = b * margin + translate;
                    }
                }
            }
            flg = true;
        }
        
        private function setHLS():void
        {
            var count:int = 0;
            for( var b:int = 0; b<6; b++ )
            {
                for( var g:int = 0; g<6; g++ )
                {
                    for( var r:int = 0; r<6; r++ ){
                        var cube:Cube = cubes[count++] as Cube;
                        toHLS( r*0x33, g*0x33, b*0x33, cube );
                    }
                }
            }
            flg = true;
        }
        
        private var rot:int = 0;
        private function render():void
        {
            if(flg)
            {
                setVertex();
            }
            
            m.identity();
            m.appendRotation( rot++, Vector3D.Y_AXIS );
            m.appendTranslation( 0, 0, 500 );
            m.append( proj.toMatrix3D() );
            
            Utils3D.projectVectors( m, vertices, pv, uvts );
            
            var face:Face;
            var inc:int = 0;
            var len:int = indices.length;
            for (var i:int = 0; i<len; i+=3)
            {
                face = faces[inc] as Face;
                face.x = indices[i];
                face.y = indices[ i + 1 ];
                face.z = indices[ i + 2 ];
                var i3:int = i*3;
                face.w = uvts[ i3 + 2 ] + uvts[ i3 + 5 ] + uvts[ i3 + 8 ];
                inc++;
            }
            inc = 0;
            faces.sortOn("w", Array.NUMERIC);
            for each (face in faces){
                sortedIndices[inc++] = face.x;
                sortedIndices[inc++] = face.y;
                sortedIndices[inc++] = face.z;
            }
            
            g.clear();
            g.beginBitmapFill( bd, null, true, false);
            g.drawTriangles( pv , sortedIndices, uvts, "negative");
            g.endFill();
        }
        
        private function create():void
        {
            vertices = new <Number>[];
            indices = new <int>[];
            sortedIndices = new <int>[];
            uvts = new <Number>[];
            faces = [];
            cubes = new Vector.<Cube>();
            pv = new Vector.<Number>();
            
            bd = new BitmapData( 216, 216, false, 0 );
            var len:int = 6;
            var s:int = 216/18;
            var rect:Rectangle = new Rectangle(0,0,s,s);
            var count:int = 0;
            var uvs:Number = 1 / 18;
            var o:Number = uvs / 2;
            var _u:Number = 0, _v:Number = 0;
            var vCount:int = -1;
            var margin:int = 20;
            var m:Matrix3D = new Matrix3D();
            translate = (-6 * margin + margin) >> 1;
            for( var b:int = 0; b<len; b++ )
            {
                for( var g:int = 0; g<len; g++ )
                {
                    for( var r:int = 0; r<len; r++ ){
                        rect.x = ( count % 18 ) * s;
                        if( count >= 18 && rect.x == 0) rect.y += s;
                        bd.fillRect( rect, (0x33*r<<16) | ( 0x33*g<<8 ) | 0x33*b );
                        
                        var cube:Cube = new Cube( r * margin + translate, g * margin + translate, b * margin + translate, 5);
                        _u = ( count % 18 ) * uvs + o ;
                        if( count % 18 == 0) vCount++;
                        _v = vCount * uvs + o;
                        uvts.push(
                            _u,_v,0, _u,_v,0, _u,_v,0,
                            _u,_v,0, _u,_v,0, _u,_v,0,
                            
                            _u,_v,0, _u,_v,0, _u,_v,0,
                            _u,_v,0, _u,_v,0, _u,_v,0,
                            
                            _u,_v,0, _u,_v,0, _u,_v,0,
                            _u,_v,0, _u,_v,0, _u,_v,0,
                            
                            _u,_v,0, _u,_v,0, _u,_v,0,
                            _u,_v,0, _u,_v,0, _u,_v,0,
                            
                            _u,_v,0, _u,_v,0, _u,_v,0,
                            _u,_v,0, _u,_v,0, _u,_v,0,
                            
                            _u,_v,0, _u,_v,0, _u,_v,0,
                            _u,_v,0, _u,_v,0, _u,_v,0
                        );
                        cubes[count] = cube;
                        count++;
                    }
                }
            }
            setVertex();
            len = vertices.length / 3;
            for( var i:int = 0; i<len; i++ ){
                indices[i]=i;
                if(i%3 == 0) faces.push( new Face() );
            }
        }
        private function setVertex():void
        {
            vertices.length = 0;
            for( var i:int =0, len:int = cubes.length; i<len; i++)
            {
                vertices = vertices.concat( cubes[i].transVertex() );
            }
            flg = false;
        }
        public function toHLS(rr:int , gg:int , bb:int, cube:Cube):void{
            var max:int = Math.max(rr,Math.max(gg,bb));
            var min:int = Math.min(rr,Math.min(gg,bb));
            var H:Number = 0;
            var L:Number = (max+min)/2;
            var S:Number = 0;
            
            if(max == min) S = H =0;
            else{
                if( L >= 128) S = ((max-min)/(max+min))*L*0.785;
                else S = ((max-min)/(2*255-max-min))*(255-L)*0.785;
                var Cr:Number = ( ((max-rr)*60) + ((max-min)/2) ) / (max-min);
                var Cg:Number = ( ((max-gg)*60) + ((max-min)/2) ) / (max-min);
                var Cb:Number = ( ((max-bb)*60) + ((max-min)/2) ) / (max-min);
                
                if(rr==max)
                    H = Cb-Cg;
                else if(gg==max)
                    H = 120+Cr-Cb;
                else
                    H = 240+Cg-Cr;
                
                if (H < 0)
                    H += 360;
                if (H > 360)
                    H -= 360;
            }
            L = (L/255)*100;
            
            var _pi2:Number = Math.PI * 2;
            var rad:Number = 360-(_pi2* (( H * 2 | 0 ) - ( H | 0 )) )/360;
            var _r:Number = 150 * (S/100);
            var h:Number = hlsHeight * (L/100);
            
            cube.x = _r * Math.sin(rad);
            cube.y = -h + ( hlsHeight / 2 );
            cube.z = _r * Math.cos(rad);
        }
        
    }//
}
import flash.geom.Matrix3D;

class Cube{
    
    public var x:Number, y:Number, z:Number;
    private var scale:Number;
    private var m:Matrix3D;
    public var vertices:Vector.<Number>;
    public function Cube( x:Number, y:Number, z:Number , scale:Number = 1)
    {
        this.x = x;
        this.y = y;
        this.z = z;
        this.scale = scale;
        m = new Matrix3D();
        vertices = new Vector.<Number>();
        transVertex();
    }
    public function transVertex():Vector.<Number>
    {
        vertices.length = 0;
        m.identity();
        m.appendScale( scale, scale, scale );
        m.appendTranslation( x, y, z );
        m.transformVectors( cube, vertices);
        return vertices;
    }
    
    {
        cube = createCube();
    }
    private static var cube:Vector.<Number>;
    private static function createCube():Vector.<Number>
    {
        if(cube) return cube;
        var vertices:Vector.<Number> = new <Number>[];
        vertices = vertices.concat( v[0], v[1], v[3] );
        vertices = vertices.concat( v[3], v[2], v[0] );
        
        vertices = vertices.concat( v[2], v[3], v[5] );
        vertices = vertices.concat( v[5], v[4], v[2] );
        
        vertices = vertices.concat( v[4], v[5], v[7] );
        vertices = vertices.concat( v[7], v[6], v[4] );
        
        vertices = vertices.concat( v[6], v[7], v[1] );
        vertices = vertices.concat( v[1], v[0], v[6] );
        
        vertices = vertices.concat( v[6], v[0], v[2] );
        vertices = vertices.concat( v[2], v[4], v[6] );
        
        vertices = vertices.concat( v[1], v[7], v[5] );
        vertices = vertices.concat( v[5], v[3], v[1] );
        return vertices;
    }
    private static const v:Vector.<Vector.<Number>> = new <Vector.<Number>>[
        new <Number>[-1, 1, 1],
        new <Number>[-1, -1, 1],
        new <Number>[1, 1, 1],
        new <Number>[1, -1, 1],
        
        new <Number>[1, 1, -1],
        new <Number>[1, -1, -1],
        new <Number>[-1, 1, -1],
        new <Number>[-1, -1, -1]
    ];
}
class Face
{
    public var w:Number, x:Number, y:Number, z:Number;
}