/**
 * Copyright momolab ( http://wonderfl.net/user/momolab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6UDL
 */

package {
    import flash.display.Sprite;
    import flash.text.engine.TextBlock;
    import flash.text.engine.TextElement;
    import flash.text.engine.TextLine;
    import flash.text.engine.ElementFormat;
    import flash.text.engine.SpaceJustifier;
    import flash.text.engine.LineJustification;
    
    public class SpaceJustifierExample extends Sprite {
        
        public function SpaceJustifierExample():void {
            var str:String = "미국 정보기술(IT) 전문매체 새너제이머큐리뉴스는 최근 애플 최고경영자(CEO) 스티브 잡스 은퇴 후 IT업계의 최고 CEO가 될 만한 후보 5명을 선정했다고 보도했다. 선정 기준은 기술 진화 방향을 예측하고 준비할 수 있는 능력,회사 사업 구조를 통째로 바꿀 수 있는 과감한 도전의식,여러 분야 전문가들을 영입해 최고의 능력을 발휘할 수 있도록 하는 팀워크,직원들이 열정을 바칠 수 있는 가치의 보유 등을 꼽았다.\
새너제이머큐리뉴스는 가장 유력한 후보자로 구글의 래리 페이지와 페이스북의 마크 저커버그를 꼽았다. 두 회사의 규모와 영향력이 이미 다른 경쟁사들과 비교하기 힘들 정도로 커졌다는 게 그 이유다. 페이지는 남들이 모두 레드오션이라 부르는 검색 시장에 뛰어들어 구글을 최대 인터넷업체로 성장시키는 능력을 보여줬다.";
            
            var format:ElementFormat = new ElementFormat(null, 12, 0xCC0000);
            var textElement:TextElement = new TextElement(str, format);
            var spaceJustifier:SpaceJustifier = new SpaceJustifier("en", LineJustification.ALL_BUT_LAST);
            spaceJustifier.letterSpacing = true;
            spaceJustifier.minimumSpacing = .2;
            var textBlock:TextBlock = new TextBlock();
            textBlock.content = textElement;
            textBlock.textJustifier = spaceJustifier;
            createLines(textBlock);
        }
        
        private function createLines(textBlock:TextBlock):void {
        
            var yPos:Number = 20;
            var textLine:TextLine = textBlock.createTextLine (null, 150);
 
            while (textLine)
            {
                addChild(textLine);
                textLine.x = 15;
                yPos += textLine.textHeight+2;
                textLine.y = yPos;
                textLine = textBlock.createTextLine(textLine, 150);
            }        
        }
    }
}