/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6SD8
 */

/**
 * Sound : http://wonderfl.net/c/3clv
*/

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BevelFilter;
    import flash.filters.BitmapFilter;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    /**
     * ...
     * @author ksnmt
     */
    [SWF(width = 465, height = 465,backgroundColor = 0x0, frameRate = 60)]
    public class Main extends Sprite {
        
        private var sound:Sound = new Sound();
        private var color:uint = 0xFFFFFF * Math.random();
        private var shape:Shape = new Shape();
        private var total:Number = 0;
        private var bitmap:Bitmap = new Bitmap(new BitmapData(465, 465, true, 0));
        
        private static const URL:String = "http://www.takasumi-nagai.com/soundfiles/sound001.mp3";
        private static const RECT:Rectangle = new Rectangle(0, 0, 465, 465);
        private static const POINT_ZERO:Point = new Point(0, 0);
        private static const FILTER:BlurFilter = new BlurFilter(16, 16);
        
        public function Main():void {
            this.addEventListener(Event.ADDED, init);
        }
        
        private function init(e:Event = null):void {
            this.removeEventListener(Event.ADDED, init);
            
            sound.load(new URLRequest(URL), new SoundLoaderContext(10, true));
            
            var sndChannel:SoundChannel = new SoundChannel();
            sndChannel = sound.play(0, 5);
            
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            this.addChild(bitmap);
        }
        
        private function onEnterFrame(e:Event):void {
            
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, true, 0);
            
            var i:int = 0;
            var k:int = 0;
            var temporaryTotal:Number = 0;
            
            shape.graphics.clear();
            for (i = 16; i < 16*3; i++) temporaryTotal += bytes[i];
            if (temporaryTotal > 3700 && (temporaryTotal != total)) {
                total = temporaryTotal;
                color = 0xFFFFFF * Math.random();
            }
            
            for (i = 1; i < 16; i++) {
                for (k = 1; k < 16; k++) {
                    shape.graphics.lineStyle(3, color);
                    const a:Number = bytes[i * 10 + k] * 0.05;
                    shape.graphics.drawCircle(k * 32, i * 32, (a > 12.67) ? 16 : (a > 10) ? 8 : 0);
                }
            }
            
            bitmap.bitmapData.applyFilter(bitmap.bitmapData, RECT, POINT_ZERO, FILTER);
            bitmap.bitmapData.draw(shape);
        }
    }
}
