/**
 * Copyright ultranoir ( http://wonderfl.net/user/ultranoir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6RqJ
 */

// forked from ProjectNya's forked from: SPEC vol.5 投稿用コード
// forked from Event's SPEC vol.5 投稿用コード
//////////////////////////////////////////////////////
//  forked from Takema.Terai's flash on 2012-7-4  ////
//////////////////////////////////////////////////////
//  card_action  /////////////////////////////////////
//////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
     import flash.events.Event;
     import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import a24.tween.Tween24;
    import a24.tween.Tween24Event;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var loaders:Array;
        private var contents:Array;
        private var cards:Array;
        private var assetsPath:String = "http://assets.wonderfl.net/images/related_images/";
        private var backPath:String = "6/6a/6a39/6a39d24903a88ef0e43693fa953fb2aabe242387";
        private var logoPath:String = "d/d3/d3a6/d3a65301bb89f0e7db4ea5b727224b8b944fba97";
        private var sliverPath:String = "c/c3/c3b9/c3b9c082c57786d6d70cd72f342b232942865a1c";
        private var goldPath:String = "f/fc/fcfb/fcfb1f18a586ad79fd30a5c08cb4f267e9714530";
        private var initialized:uint = 0;
        private var eclipse:FlareCircle;
        private var twinkle:Twinkle;

        public function Main() {
            //Wonderfl.capture_delay(1);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            eclipse = new FlareCircle(new Rectangle(0, 0, 460, 460), 215);
            eclipse.x = 2;
            eclipse.y = 2;
            //
            twinkle = new Twinkle(new Rectangle(0, 0, 400, 400));
            twinkle.x = 32;
            twinkle.y = 32;
            contents = new Array();
            contents.push({content: null, scale: 1, x: 0, y: 0});
            contents.push({content: null, scale: 2, x: 24, y: 26});
            contents.push({content: null, scale: 1, x: 232, y: 232});
            contents.push({content: null, scale: 1, x: 232, y: 232});
            //
            cards = new Array();
            //
            var imagePaths:Array = new Array();
            imagePaths = [backPath, logoPath, sliverPath, goldPath];
            loaders = new Array();
            for (var n:uint = 0; n < 4; n++) {
                var loader:ImageLoader = new ImageLoader();
                loader.id = n;
                loader.addEventListener(ImageLoader.COMPLETE, complete, false, 0, true);
                var imagePath:String = assetsPath + imagePaths[n];
                loader.load(imagePath, true);
                loaders.push(loader);
            }
        }
        private function complete(evt:Event):void {
            var loader:ImageLoader = ImageLoader(evt.target);
            loader.removeEventListener(ImageLoader.COMPLETE, complete);
            contents[loader.id].content = loader.content;
            initialize();
        }
        private function initialize():void {
            initialized ++;
            if (initialized > 4 - 1) setup();
        }
        private function setup():void {
            for (var n:uint = 0; n < 4; n++) {
                var info:Object = contents[n];
                var content:Bitmap = Bitmap(info.content);
                if (n < 2) {
                    addChild(content);
                    content.scaleX = content.scaleY = info.scale;
                    content.x = info.x;
                    content.y = info.y;
                }
                if (n == 2) createSlilverCard(content);
                if (n == 3) createGoldCard(content);
            }
            addChild(eclipse);
            addChild(twinkle);
            //
            start();
        }
        private function start():void {
            var tweens1:Array = new Array();
            var tweens2:Array = new Array();
            for (var n:uint = 0; n < 12; n++) {
                var card:Card = cards[n];
                var tween1:Tween24 = Tween24.serial(
                    Tween24.tween(card, 0.1, Tween24.ease.Linear).bright(2.55).fadeIn(), 
                    Tween24.tween(card, 0.6, Tween24.ease.Linear).bright(0)
                ).delay(0.025*n);
                tweens1.push(tween1);
                var tween2:Tween24 = Tween24.parallel(
                    Tween24.tween(card, 0.8, Tween24.ease.QuadOut, {radius: 40}), 
                    Tween24.tween(card, 0.8, Tween24.ease.Linear, {angle: (30*n - 60) + 360})
                );
                tweens2.push(tween2);
            }
            var gold:Card = cards[12];
            var atween:Tween24 = Tween24.serial(
                Tween24.parallel(
                    Tween24.parallel.apply(Tween24.parallel, tweens1), 
                    Tween24.func(eclipse.start).delay(0.4)
                ), 
                Tween24.parallel.apply(Tween24.parallel, tweens2), 
                Tween24.tween(gold, 0.1, Tween24.ease.Linear).bright(2.55).fadeIn(), 
                Tween24.tween(gold, 0.2, Tween24.ease.Linear).bright(0), 
                Tween24.tween(gold, 0.4, Tween24.ease.QuadIn).rotation(360), 
                Tween24.tween(gold, 0.6, Tween24.ease.ElasticOut).scale(2), 
                Tween24.func(twinkle.start)
            );
            atween.addEventListener(Tween24Event.UPDATE, update, false, 0, true);
            atween.play();
        }
        private function update(evt:Tween24Event):void {
            for (var n:uint = 0; n < 12; n++) {
                var card:Card = cards[n];
                card.update();
            }
        }
        private function createSlilverCard(content:Bitmap):void {
            for (var n:uint = 0; n < 12; n++) {
                var card:Card = new Card(content.bitmapData);
                addChild(card);
                card.scaleX = card.scaleY = 0.4;
                card.radius = 160;
                card.angle = 30*n - 60;
                card.update();
                card.visible = false;
                cards.push(card);
            }
        }
        private function createGoldCard(content:Bitmap):void {
            var card:Card = new Card(content.bitmapData);
            addChild(card);
            card.x = 232;
            card.y = 232;
            card.visible = false;
            cards.push(card);
        }
        
    }

}


//////////////////////////////////////////////////
// Cardクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;

class Card extends Sprite {
    private var bitmapData:BitmapData;
    public var radius:Number = 0;
    public var angle:Number = 0;
    private var radian:Number = Math.PI/180;

    public function Card(bd:BitmapData) {
        bitmapData = bd.clone();
        init();
    }

    private function init():void {
        var content:Bitmap = new Bitmap(bitmapData);
        addChild(content);
        content.smoothing = true;
        content.x = - bitmapData.width/2;
        content.y = - bitmapData.height/2;
    }
    public function update():void {
        x = 232 + radius*Math.cos(angle*radian);
        y = 232 + radius*Math.sin(angle*radian);
    }

}


//////////////////////////////////////////////////
// Twinkleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.utils.Dictionary;
import flash.utils.Timer;
import flash.events.TimerEvent;

class Twinkle extends Sprite {
    private var rect:Rectangle;
    private var id:uint = 0;
    private var particles:Dictionary;
    private var timer:Timer;
    private static var interval:uint = 20;

    public function Twinkle(r:Rectangle) {
        rect = r;
    }

    public function start():void {
        id = 0;
        particles = new Dictionary(true);
        create();
        timer = new Timer(interval);
        timer.addEventListener(TimerEvent.TIMER, create, false, 0, true);
        timer.start();
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function stop():void {
        if (timer) {
            timer.stop();
            timer.removeEventListener(TimerEvent.TIMER, create);
            timer = null;
        }
    }
    private function create(evt:TimerEvent = null):void {
        var radius:Number = 15 + Math.random()*15;
        var particle:ParticleLight = new ParticleLight(6, radius);
        addChild(particle);
        particle.id = id;
        particle.x = uint(Math.random()*rect.width);
        particle.y = uint(Math.random()*rect.height);
        particle.rotation = Math.random()*360;
        particles[id] = particle;
        particle.addEventListener(Event.COMPLETE, complete, false, 0, true);
        particle.start();
        id ++;
    }
    private function complete(evt:Event):void {
        var particle:ParticleLight = ParticleLight(evt.target);
        particle.removeEventListener(Event.COMPLETE, complete);
        removeChild(particle);
        delete particles[particle.id];
        particle = null;
    }
    private function update(evt:Event):void {
        var count:uint = 0;
        for (var n:String in particles) {
            if (particles[n]) count++;
        }
        if (count < 1) {
            removeEventListener(Event.ENTER_FRAME, update);
            dispatchEvent(new Event(Event.COMPLETE));
        }
    }

}


//////////////////////////////////////////////////
// ParticleLightクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.display.Shape;
import flash.filters.GlowFilter;
import flash.display.BlendMode;
import a24.tween.Tween24;
import a24.tween.Tween24Event;
import frocessing.color.ColorHSV;

class ParticleLight extends Sprite {
    public var id:uint;
    private static var unit:uint = 6;
    private static var radius:uint = 25;
    private static var blur:Number = 16;
    private var color:ColorHSV;
    private var atween:Tween24;

    public function ParticleLight(u:uint = 6, r:uint = 25) {
        unit = u;
        radius = r;
        blur = radius*0.64;
        init();
    }

    private function init():void {
        var hue:Number = Math.random()*360;
        color = new ColorHSV(hue, 0.5);
        draw();
        alpha = 0;
        visible = false;
        scaleX = scaleY = 0;
        blendMode = BlendMode.ADD;
    }
    public function start():void {
        atween = Tween24.serial(
            Tween24.tween(this, 0.3, Tween24.ease.ExpoOut).fadeIn().scale(1), 
            Tween24.tween(this, 1.2, Tween24.ease.QuadOut).fadeOut().scale(0)
        );
        atween.addEventListener(Tween24Event.COMPLETE, complete, false, 0, true);
        atween.play();
    }
    private function complete(evt:Tween24Event):void {
        atween.removeEventListener(Tween24Event.COMPLETE, complete);
        dispatchEvent(new Event(Event.COMPLETE));
    }
    private function draw():void {
        for (var n:uint = 0; n < unit; n++) {
            var shape:Shape = new Shape();
            addChild(shape);
            shape.graphics.beginFill(color.value);
            shape.graphics.moveTo(0, -radius*0.1);
            shape.graphics.curveTo(0, 0, radius, 0);
            shape.graphics.curveTo(0, 0, 0, radius*0.1);
            shape.graphics.endFill();
            shape.rotation = 360/unit*n;
        }
        filters = [new GlowFilter(color.value, 1, blur, blur, 4, 3, false, false)];
    }

}


//////////////////////////////////////////////////
// FlareCircleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.display.Shape;
import flash.geom.Rectangle;

class FlareCircle extends Sprite {
    private var rect:Rectangle;
    private var radius:uint;
    private var shape:Shape;
    private var flare:FlareMap;
    private var detection:DetectPixels;

    public function FlareCircle(area:Rectangle, r:uint) {
        rect = area;
        radius = r;
        init();
    }

    private function init():void {
        shape = new Shape();
        shape.graphics.lineStyle(8, 0xFFFFFF, 0.5);
        shape.graphics.drawCircle(rect.width/2, rect.height/2, radius);
        //addChild(shape);
        shape.x = rect.x;
        shape.y = rect.y;
        flare = new FlareMap(rect);
        addChild(flare);
        flare.x = rect.x + rect.width/2;
        flare.y = rect.y + rect.height/2;
        detection = new DetectPixels(2);
        detection.search(shape, rect, 0x66FFFFFF);
        flare.map = detection.pixels();
        flare.setup(60);
        flare.addEventListener(Event.COMPLETE, complete, false, 0, true);
        //flare.start();
    }
    public function start():void {
        flare.start();
    }
    public function stop():void {
        flare.stop();
    }
    private function complete(evt:Event):void {
        dispatchEvent(new Event(Event.COMPLETE));
    }

}


//////////////////////////////////////////////////
// FlareMapクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.display.BlendMode;
//import sketchbook.colors.ColorUtil;

class FlareMap extends Sprite {
    private var rect:Rectangle;
    private var fire:Rectangle;
    private var flare:BitmapData;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var rPalette:Array;
    private var gPalette:Array;
    private var bPalette:Array;
    private static var point:Point = new Point(0, 0);
    private var speeds:Point = new Point(0, 0);
    private static var unit:uint = 2;
    private var segments:uint = 8;
    private var blur:BlurFilter;
    private var maps:Array;
    public var offset:Object = {x: 0, y: 0};
    private var faded:uint = 0;
    public static const COMPLETE:String = Event.COMPLETE;

    public function FlareMap(r:Rectangle) {
        rect = r;
        initialize();
        draw();
    }

    public function setup(seg:uint = 8):void {
        segments = seg;
    }
    public function set map(list:Array):void {
        maps = list;
    }
    private function initialize():void {
        rPalette = new Array();
        gPalette = new Array();
        bPalette = new Array();
        for (var n:uint = 0; n < 256; n++) {
            var luminance:uint = (n < 128) ? n*2 : 0;
            //var rgb:Object = ColorUtil.HLS2RGB(n*360/256, luminance, 100);
            var rgb:Object = HLS2RGB(n*360/256, luminance, 100);
            var color:uint = rgb.r << 16 | rgb.g << 8 | rgb.b;
            rPalette[n] = color;
            gPalette[n] = 0;
            bPalette[n] = 0;
        }
        blur = new BlurFilter(4, 4, 3);
        blendMode = BlendMode.ADD;
    }
    private function draw():void {
        fire = new Rectangle(0, 0, rect.width, rect.height);
        flare = new BitmapData(fire.width, fire.height, false, 0xFF000000);
        bitmapData = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        bitmap.x = - rect.width/2;
        bitmap.y = - rect.height/2;
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, update);
        faded = 0;
        addEventListener(Event.ENTER_FRAME, clear, false, 0, true);
    }
    private function update(evt:Event):void {
        if (!maps) return;
        flare.lock();
        bitmapData.lock();
        for (var n:uint = 0; n < segments; n++) {
            var id:uint = Math.random()*maps.length;
            var px:int = maps[id].x + offset.x;
            var py:int = maps[id].y + offset.y;
            var range:Rectangle = new Rectangle(px, py, unit, unit)
            flare.fillRect(range, 0xFFFFFF);
        }
        flare.applyFilter(flare, fire, speeds, blur);
        bitmapData.paletteMap(flare, rect, point, rPalette, gPalette, bPalette);
        flare.unlock();
        bitmapData.unlock();
    }
    private function clear(evt:Event):void {
        faded ++;
        flare.lock();
        bitmapData.lock();
        flare.applyFilter(flare, fire, speeds, blur);
        bitmapData.paletteMap(flare, rect, point, rPalette, gPalette, bPalette);
        if (faded > 20) {
            bitmapData.fillRect(rect, 0x000000);
            removeEventListener(Event.ENTER_FRAME, clear);
            dispatchEvent(new Event(FlareMap.COMPLETE));
        }
        flare.unlock();
        bitmapData.unlock();
    }
    private function HLS2RGB(h:Number, l:Number, s:Number):Object{
        var max:Number;
        var min:Number;
        h = (h < 0)? h % 360+360 : (h>=360)? h%360: h;
        l = (l < 0)? 0 : (l > 100)? 100 : l;
        s = (s < 0)? 0 : (s > 100)? 100 : s;
        l *= 0.01;
        s *= 0.01;
        if (s == 0) {
            var val:Number = l*255;
            return {r:val, g:val, b:val};
        }
        if (l < 0.5) {
            max = l*(1 + s)*255;
        } else {
            max = (l*(1 - s) + s)*255;
        }
        min = (2*l)*255 - max;
        return _hMinMax2RGB(h, min, max);
    }
    private function _hMinMax2RGB(h:Number, min:Number, max:Number):Object{
        var r:Number;
        var g:Number;
        var b:Number;
        var area:Number = Math.floor(h/60);
        switch(area){
            case 0:
                r = max;
                g = min + h * (max - min)/60;
                b = min;
                break;
            case 1:
                r = max - (h - 60)*(max - min)/60;
                g = max;
                b = min;
                break;
            case 2:
                r = min ;
                g = max;
                b = min + (h - 120)*(max - min)/60;
                break;
            case 3:
                r = min;
                g = max - (h - 180)*(max - min)/60;
                b =max;
                break;
            case 4:
                r = min + (h - 240)*(max - min)/60;
                g = min;
                b = max;
                break;
            case 5:
                r = max;
                g = min;
                b = max - (h - 300)*(max - min)/60;
                break;
            case 6:
                r = max;
                g = min + h*(max - min)/60;
                b = min;
                break;
        }
        r = Math.min(255, Math.max(0, Math.round(r)));
        g = Math.min(255, Math.max(0, Math.round(g)));
        b = Math.min(255, Math.max(0, Math.round(b)));
        return {r:r, g:g, b:b};
    }

}


//////////////////////////////////////////////////
// DetectPixelsクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80FFFFFF;
    private var offset:Object = {x: 0, y: 0};

    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }

    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF, o:Object = null):void {
        bd = t;
        rect = r;
        threshold = th;
        if (o) offset = o;
        var w:uint = rect.width/accuracy;
        var h:uint = rect.height/accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.translate(-rect.x, -rect.y);
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for (var x:uint = 0; x < w; x++) {
            for (var y:uint = 0; y < h; y++) {
                var color:uint = map.getPixel32(x, y);
                if (color >= threshold) {
                    var px:int = x*accuracy + rect.x + offset.x;
                    var py:int = y*accuracy + rect.y + offset.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }

}


//////////////////////////////////////////////////
// PerlinNoiseクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;

class PerlinNoise extends BitmapData {
    private var bx:uint;
    private var by:uint;
    private var octaves:uint;
    private var seed:uint;
    private var stitch:Boolean = true;
    private var fractalNoise:Boolean = true;
    private var channel:uint = 0;
    private var grayScale:Boolean = true;
    private var offsets:Array = new Array();

    public function PerlinNoise(rect:Rectangle, x:uint, y:uint, o:uint = 1, g:Boolean = true, c:uint = 0, s:uint = 1, st:Boolean = false, f:Boolean = true) {
        super(rect.width, rect.height, false, 0xFF000000);
        bx = x;
        by = y;
        octaves = o;
        grayScale = g;
        channel = c;
        if (grayScale) channel = 0;
        for (var n:uint = 0; n < octaves; n++) {
            var point:Point = new Point();
            offsets.push(point);
        }
        stitch = st;
        fractalNoise = f;
        create(s, offsets);
    }

    private function create(s:uint, o:Array = null):void {
        seed = s;
        offsets = o;
        if (offsets == null) offsets = [new Point()];
        lock();
        perlinNoise(bx, by, octaves, seed, stitch, fractalNoise, channel, grayScale, offsets);
        draw(this);
        unlock();
    }
    public function update(speeds:Array):void {
        for (var n:uint = 0; n < octaves; n++) {
            var offset:Point = offsets[n];
            var speed:Point = speeds[n];
            offset.x += speed.x;
            offset.y += speed.y;
        }
        lock();
        perlinNoise(bx, by, octaves, seed, stitch, fractalNoise, channel, grayScale, offsets);
        draw(this);
        unlock();
    }

}


//////////////////////////////////////////////////
// ImageLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.LoaderContext;

class ImageLoader extends EventDispatcher {
    public var id:uint;
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:Bitmap;
    private var smoothing:Boolean;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function ImageLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            //Security.allowDomain("assets.wonderfl.net");
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        trace(evt.text);
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        trace(evt.status);
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        trace(evt.text);
    }
    private function initialize(evt:Event):void {
        content = Bitmap(info.content);
        if (smoothing) {
            content.smoothing = true;
        }
        dispatchEvent(new Event(ImageLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        //addChild(loader);
        dispatchEvent(new Event(ImageLoader.COMPLETE));
    }

}
