/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6RnR
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Vector3D;
    import flash.geom.PerspectiveProjection;
     
    [SWF(width=1000, height=618)]
    
    public class LocalGlobal extends Sprite
    {
        public  var SW:Number   = new Number( stage.stageWidth  );
        public  var SH:Number   = new Number( stage.stageHeight );
        public  var SD:Number   = new Number( 5000              );
        public  var groundZero:Vector3D = new Vector3D( SW/2,SH/2,0,0 );
      //public  var groundZero:Vector3D = new Vector3D( SW/2,SH/2,SD/2,0 );
        private var _sprite:Sprite;
        private var _tracker:Sprite;
        private var _angle:Number = 0;
        private var perspective:PerspectiveProjection;
        private var point:Point;
    
        public function LocalGlobal()
        {
            point        = new Point( SW/2,SH/2 );
            perspective  = new PerspectiveProjection();
            _sprite      = new Sprite();
            _tracker     = new Sprite();
            
            perspective.fieldOfView = 58;
            perspective.projectionCenter = point;
            transform.perspectiveProjection = perspective;
            
            _sprite.graphics.lineStyle(10);
            //_sprite.graphics.lineTo( 200, 0   );
            _sprite.graphics.lineTo(   200, 0  );
            _sprite.graphics.lineTo(  -200, 0  );
            _sprite.graphics.drawCircle(  200,0,20 );
            _sprite.graphics.drawCircle( -200,0,20 );
            _sprite.x = SW/2;
            _sprite.y = SH/2;
            addChild(_sprite);
            
            _tracker.graphics.lineStyle( 6,0xff0000 );
            _tracker.graphics.beginFill( 0x131413,0.6 ); 
            _tracker.graphics.drawCircle( 0,0,60 );
            addChild(_tracker);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrameMethod); 
        }
            
        private function onEnterFrameMethod(event:Event = null):void
        {
            var _locToGlobal3D:Vector3D = new Vector3D( 200,0,0 );
            var p:Point = _sprite.local3DToGlobal( _locToGlobal3D );
            var p3D:Vector3D = new Vector3D( p.x,p.y,_tracker.z );
            
            _sprite.rotationX += 1;
            _sprite.rotationY += 1.2;
            _sprite.rotationZ += .5;
            _sprite.x = groundZero.x + Math.cos(_angle);// * 100;
            _sprite.y = groundZero.y + Math.sin(_angle);// * 100;
            _sprite.z = groundZero.z + Math.cos(_angle * .8);// * 400;
            _angle += .05;

            _tracker.x = p3D.x; 
            _tracker.y = p3D.y;
            _tracker.z = p3D.z;
        }
        
        
    }//END pub class
}//END Package