/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6RmK
 */

package {
    import flash.display.Sprite;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.easing.*;
    
    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]
    
    public class FlashTest extends Sprite {
        
        public function FlashTest() {
            init();            
        }
        
        private function init():void {
            var wondflcolor:WonderflColor = new WonderflColor(465, 465);
            addChild(wondflcolor);
            //
            var wonderfllogo:WonderflLogo = new WonderflLogo();
            addChild(wonderfllogo);
            wonderfllogo.scaleX = wonderfllogo.scaleY = 0.6;
            wonderfllogo.x = (stage.stageWidth  - wonderfllogo.width  >> 1) -  2;
            wonderfllogo.y = (stage.stageHeight - wonderfllogo.height >> 1) - 15;
            //
            var subtitle:Label = new Label(200, 20, 14, Label.CENTER);
            addChild(subtitle);
            subtitle.x = 132;
            subtitle.y  =242;
            subtitle.textColor = 0xFFFFFF;
            subtitle.text = "build flash online";
            //
            wonderfllogo.alpha = 0;
            subtitle.alpha = 0;
            //
            var itween:ITween = BetweenAS3.parallel(
                BetweenAS3.to(wonderfllogo, {alpha: 1}, 2, Linear.easeNone), 
                BetweenAS3.delay(BetweenAS3.to(subtitle, {alpha: 1}, 1.5, Linear.easeNone), 1)
            );
            itween.play();
        }
    }
}

import flash.display.Shape;
import flash.display.GradientType;
import flash.geom.Matrix;

class WonderflLogo extends Shape {
    private static const WC:Vector.<int> = new <int>[1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2];
    private static const WD:Vector.<Number> = new <Number>[0, 24.5, 8.5, 24.5, 17, 59, 28.5, 24.5, 36.5, 24.5, 48.5, 59, 56.5, 24.5, 65.5, 24.5, 53.5, 69.5, 44.5, 69.5, 32.5, 36.5, 20.5, 69.5, 11.5, 69.5];
    private static const OC:Vector.<int> = new <int>[1, 3, 3, 3, 3, 1, 3, 3, 3, 3];
    private static const OD:Vector.<Number> = new <Number>[79.5, 46, 79.5, 31, 94, 31, 106.5, 31, 107, 46, 107, 63, 94, 63, 78.5, 63, 79.5, 46, 71, 46, 71, 24.5, 94, 24.5, 115, 24.5, 115.5, 46, 115.5, 69.5, 94, 69.5, 71, 69.5, 71, 46];
    private static const NC:Vector.<int> = new <int>[1, 2, 2, 3, 3, 2, 2, 2, 3, 3, 2, 2];
    private static const ND:Vector.<Number> = new <Number>[125.5, 25, 133, 25, 134, 31, 142, 24.5, 150, 24.5, 166, 24.5, 167.5, 39, 167.5, 69.5, 159, 69.5, 159, 39, 157, 31.5, 148, 31.5, 141.5, 31.5, 135.5, 37, 135.5, 69.5, 125.5, 69.5];
    private static const DC:Vector.<int> = new <int>[1, 3, 3, 2, 3, 3, 1, 3, 3, 2, 2, 2, 3, 3];
    private static const DD:Vector.<Number> = new <Number>[184.5, 47, 184.5, 32, 199, 32, 202, 32, 209.5, 34, 209.5, 62, 205.5, 63, 199, 63, 184.5, 63, 184.5, 47, 176, 47, 176, 25, 198, 25, 204.5, 25, 209.5, 27, 209.5, 9, 218, 9, 218, 67, 213, 70, 198, 70, 176, 70, 176, 47];
    private static const EC:Vector.<int> = new <int>[1, 3, 3, 1, 3, 3, 2, 3, 3, 2, 3, 3];
    private static const ED:Vector.<Number> = new <Number>[236, 42.5, 236, 32, 248, 31, 260, 31, 259.5, 42.5, 227.5, 47, 227.5, 24.5, 249, 24.5, 272, 24.5, 267, 49.5, 236, 49.5, 236, 62, 252, 63, 257, 63, 266.5, 62, 266.5, 68, 261, 69.5, 251, 69.5, 227.5, 69.5, 227.5, 47];
    private static const RC:Vector.<int> = new <int>[1, 2, 2, 3, 2, 3, 2, 2];
    private static const RD:Vector.<Number> = new <Number>[280, 24.5, 286, 24.5, 287, 30.5, 292.5, 24.5, 300.5, 24.5, 300.5, 31, 295.5, 30.875, 288.5, 36.5, 288.5, 69.5, 280, 69.5];
    private static const FC:Vector.<int> = new <int>[1, 3, 3, 2, 3, 3, 2, 2, 2, 2, 2, 2];
    private static const FD:Vector.<Number> = new <Number>[311.5, 24, 311.5, 6, 329, 5.75, 338, 6, 339.5, 8.5, 339.5, 14.5, 334, 12.5, 329, 12.5, 321, 12.5, 320.5, 20, 320.5, 24.5, 334.5, 24.5, 334.5, 31.5, 320.5, 31.5, 320.5, 70, 311.5, 70];
    private static const LC:Vector.<int> = new <int>[1, 2, 2, 2];
    private static const LD:Vector.<Number> = new <Number>[345.5, 6, 353.5, 6, 353.5, 70, 345.5, 70];

    public function WonderflLogo() {
        graphics.beginFill(0x000000, 1);
        graphics.drawPath(WC, WD);
        graphics.drawPath(OC, OD);
        graphics.drawPath(NC, ND);
        graphics.drawPath(DC, DD);
        graphics.drawPath(EC, ED);
        graphics.drawPath(RC, RD);
        //
        var m:Matrix = new Matrix();
        m.createGradientBox(1, 64, Math.PI / 2);
        graphics.beginGradientFill(GradientType.LINEAR, [0xcc0000, 0x251815], [1, 1], [64, 255], m);
        graphics.drawPath(FC, FD);
        graphics.drawPath(LC, LD);
    }

}

import flash.display.Sprite;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class WonderflColor extends Sprite {
    private var color1:uint = 0x00AAE4;
    private var color2:uint = 0x0069A0;
    
    public function WonderflColor(w:uint, h:uint) {
        draw(w, h);
    }
    
    private function draw(w:uint, h:uint):void {
        var colors:Array = [color1, color2];
        var alphas:Array = [1, 1];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w*1.5, h*1.5, 0, -w*0.25, -h*0.25);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        graphics.drawRect(0, 0, w, h);
        graphics.endFill();
    }
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.display.BlendMode;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;
    
    public function Label(w:uint, h:uint, s:uint=12, align:String=LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
        blendMode = BlendMode.LAYER;
    }
    
    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
      txt.textColor = param;  
    }
}

