/**
 * Copyright hacker_e31e8142 ( http://wonderfl.net/user/hacker_e31e8142 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6RFz
 */

// forked from kotobuki's Prototyping Lab: Recipe 9.4
package {
  import flash.events.Event;

  import org.papervision3d.cameras.*;
  import org.papervision3d.materials.*;
  import org.papervision3d.materials.utils.MaterialsList;
  import org.papervision3d.objects.*;
  import org.papervision3d.objects.primitives.Cube;
  import org.papervision3d.scenes.*;
  import org.papervision3d.view.*;

  import funnel.*;
  import funnel.gui.*;

  public class MeasuringTheTilt extends BasicView {
    // Arduino
    private var arduino:Arduino;

    // 加速度センサのx軸に接続したピン
    private var xAxisPin:Pin;

    // 加速度センサのy軸に接続したピン
    private var yAxisPin:Pin;

    // 立方体
    private var cube:Cube;

    public function MeasuringTheTilt() {
      // Arduinoのインスタンスを生成
      arduino = new Arduino(Arduino.FIRMATA);

      // x軸とy軸に接続したピンを初期化
      xAxisPin = arduino.analogPin(0);
      yAxisPin = arduino.analogPin(1);

      // x軸とy軸に細かな変動を取り除くためのConvolutionフィルタと
      // スケーリングするためのScalerフィルタをセットする
      xAxisPin.addFilter(new Convolution(
                         Convolution.MOVING_AVERAGE));
      xAxisPin.addFilter(new Scaler(0.3, 0.7, -1, 1));
      yAxisPin.addFilter(new Convolution(
                         Convolution.MOVING_AVERAGE));
      yAxisPin.addFilter(new Scaler(0.3, 0.7, -1, 1));

      // 確認用のGUIを生成してセット
      var gui:ArduinoGUI = new ArduinoGUI();
      addChild(gui);
      arduino.gui = gui;

      // 立方体のためのマテリアルを準備
      var mat:MaterialsList = new MaterialsList();
      mat.addMaterial(new ColorMaterial(0xFF0000), "front");
      mat.addMaterial(new ColorMaterial(0x00FF00), "back");
      mat.addMaterial(new ColorMaterial(0x0000FF), "right");
      mat.addMaterial(new ColorMaterial(0xFFFF00), "left");
      mat.addMaterial(new ColorMaterial(0xFF00FF), "top");
      mat.addMaterial(new ColorMaterial(0x00FFFF), "bottom");

      // 立方体のインスタンスを生成
      cube = new Cube(mat, 200, 200, 200);
      scene.addChild(cube);

      // レンダリング開始
      startRendering();
    }

    override protected function onRenderTick(e:Event = null):void {
      // 立方体の角度をセット
      cube.rotationZ
        = Math.asin(yAxisPin.value) * 180 / Math.PI;
      cube.rotationX
        = Math.asin(xAxisPin.value) * 180 / Math.PI;

      // シーンをレンダリング
      renderer.renderScene(scene, camera, viewport);
    }
  }
}
