/**
 * Copyright H.S ( http://wonderfl.net/user/H.S )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6RDb
 */

package {
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    public class FriedEgg extends Sprite {
        public var radius1:Number = 48;
        public var centreX1:Number = 465 / 2;
        public var centreY1:Number = 465 / 2;
        public var centreX2:Number = 465 / 2;
        public var centreY2:Number = 465 / 2;
        public var destinationX:Number = 465 / 2;
        public var destinationY:Number = 465 / 2;
        public var lengthToDestination:Number = 0;
        public var angleToDestination:Number = Math.PI / 2;
        public var speed:int = 8;
        public var eyeSize:Number = 7;
        public var colorA:int = 0x00A2E8;//Background
        public var colorB:int = 0xFFFFFF;//White
        public var colorC:int = 0xFABD00;//Yolk(Fill)
        public var colorD:int = 0xFABD00;//Yolk(Line)
        public var colorE:int = 0x803300;//Eye
        public var colorF:int = 0xD76446;//Mouth
        public var array:Array = [];
        public var faceShape:Shape = new Shape();
        public var timer:Timer = new Timer(1000, 1);
        public function FriedEgg():void {
            addChild(faceShape);
            timer.addEventListener(TimerEvent.TIMER, function(event:TimerEvent):void {
                addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            });
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        public function enterFrameHandler(event:Event):void {
            graphics.clear();
            //背景
            graphics.beginFill(colorA);
            graphics.drawRect(0, 0, 465, 465);
            //白身
            if (array.length == 0) array = createArray();
            graphics.beginFill(colorB);
            for (var i:int; i < 8; i++) {
                var controlX1:Number = centreX1 + array[i * 3 + 1] * Math.cos(Math.PI / 12 * (i * 3 + 1));
                var controlY1:Number = centreY1 + array[i * 3 + 1] * Math.sin(Math.PI / 12 * (i * 3 + 1));
                var controlX2:Number = centreX1 + array[i * 3 + 2] * Math.cos(Math.PI / 12 * (i * 3 + 2));
                var controlY2:Number = centreY1 + array[i * 3 + 2] * Math.sin(Math.PI / 12 * (i * 3 + 2));
                var anchorX:Number =   centreX1 + array[i * 3 + 3] * Math.cos(Math.PI / 12 * (i * 3 + 3));
                var anchorY:Number =   centreY1 + array[i * 3 + 3] * Math.sin(Math.PI / 12 * (i * 3 + 3));
                if (i == 0) graphics.moveTo(centreX1 + array[0], centreY1);
                graphics.cubicCurveTo(controlX1, controlY1, controlX2, controlY2, anchorX, anchorY);
            }
            graphics.endFill();
            //黄身
            var opposite:Number = Math.round(Math.sqrt(Math.pow(centreX2 - centreX1, 2) + Math.pow(centreY2 - centreY1, 2)) / 2);
            var radius2:Number = 20;
            if (opposite >= radius1) {
                var rightMargin:Number = Math.cos(Math.asin(radius1 / (radius1 + radius2))) * (radius1 + radius2) - radius2;
                rightMargin -= (rightMargin - 8) / (lengthToDestination / 2 - radius1) * (opposite - radius1);
                radius2 = (rightMargin * rightMargin + opposite * opposite - radius1 * radius1) / (radius1 * 2 - rightMargin * 2);
            }
            var angle1:Number = Math.asin(opposite / (radius2 + radius1));
            var angle2:Number = Math.PI / 2 - angle1;
            var centreX3:Number = centreX1 + Math.cos(angleToDestination + angle2) * (radius1 + radius2);
            var centreY3:Number = centreY1 + Math.sin(angleToDestination + angle2) * (radius1 + radius2);
            var centreX4:Number = centreX1 + Math.cos(angleToDestination - angle2) * (radius1 + radius2);
            var centreY4:Number = centreY1 + Math.sin(angleToDestination - angle2) * (radius1 + radius2);
            graphics.beginFill(colorC);
            graphics.lineStyle(4, colorD);
            for (var j:int; j < 21; j++) {
                var x1:Number = centreX1 + Math.cos((Math.PI * 2 - angle2 * 2) / 20 * j + angle2 + angleToDestination) * radius1;
                var y1:Number = centreY1 + Math.sin((Math.PI * 2 - angle2 * 2) / 20 * j + angle2 + angleToDestination) * radius1;
                if (j == 0) graphics.moveTo(x1, y1);
                else graphics.lineTo(x1, y1);
            }
            for (var k:int; k < 11; k++) {
                var x2:Number = centreX4 - Math.cos(angle1 * 2 / 10 * k + angle2 - angleToDestination) * radius2;
                var y2:Number = centreY4 + Math.sin(angle1 * 2 / 10 * k + angle2 - angleToDestination) * radius2;
                graphics.lineTo(x2, y2);
            }
            for (var l:int; l < 21; l++) {
                var x3:Number = centreX2 - Math.cos((Math.PI * 2 - angle2 * 2) / 20 * l + angle2 + angleToDestination) * radius1;
                var y3:Number = centreY2 - Math.sin((Math.PI * 2 - angle2 * 2) / 20 * l + angle2 + angleToDestination) * radius1;
                graphics.lineTo(x3, y3);
            }
            for (var m:int; m < 11; m++) {
                var x4:Number = centreX3 + Math.cos(angle1 * 2 / 10 * m + angle2 - angleToDestination) * radius2;
                var y4:Number = centreY3 - Math.sin(angle1 * 2 / 10 * m + angle2 - angleToDestination) * radius2;
                graphics.lineTo(x4, y4);
            }
            graphics.endFill();
            //顔
            faceShape.x = centreX2;
            faceShape.y = centreY2;
            faceShape.rotation = (angleToDestination - Math.PI / 2) * 180 / Math.PI;
            faceShape.graphics.clear();
            faceShape.graphics.beginFill(colorE);
            if (eyeSize < 7) eyeSize++;
            else if (opposite > radius1 && Math.floor(Math.random() * 70) < 1) eyeSize = 2;
            faceShape.graphics.drawCircle(27, 0, eyeSize);
            faceShape.graphics.drawCircle( -27, 0, eyeSize);
            faceShape.graphics.endFill();
            faceShape.graphics.lineStyle(5, colorF);
            for (var n:int; n < 13; n++) {
                var mouthRadius:Number = 7;
                var direction:int = (n <= 6)? 1: -1;
                var mouthX:Number = (mouthRadius + Math.cos(Math.PI / 6 * n) * mouthRadius) * direction;
                var mouthY:Number = 20 + Math.sin(Math.PI / 6 * n) * mouthRadius * direction;
                if (n == 0) faceShape.graphics.moveTo(mouthX, mouthY);
                else faceShape.graphics.lineTo(mouthX, mouthY);
            }
            //移動
            if (Math.round(Math.sqrt(Math.pow(destinationX - centreX2, 2) + Math.pow(destinationY - centreY2, 2))) >= speed) {
                centreX2 += Math.cos(angleToDestination) * speed;
                centreY2 += Math.sin(angleToDestination) * speed;
            }
            else if (centreX1 != centreX2 || centreY1 != centreY2) {
                centreX1 += Math.cos(angleToDestination) * speed;
                centreY1 += Math.sin(angleToDestination) * speed;
                if (opposite / (speed / 2) % 4 == 0) array = createArray();
            }
            else {
                lengthToDestination = 0;
                while (lengthToDestination < radius1 * 4) {
                    destinationX = radius1 + Math.floor(Math.random() * (466 - radius1 * 2));
                    destinationY = radius1 + Math.floor(Math.random() * (466 - radius1 * 2));
                    lengthToDestination = Math.sqrt(Math.pow(destinationX - centreX1, 2) + Math.pow(destinationY - centreY1, 2));
                    lengthToDestination -= lengthToDestination % speed;
                    angleToDestination = Math.atan2(destinationY - centreY1, destinationX - centreX1);
                    destinationX = centreX1 + Math.cos(angleToDestination) * lengthToDestination; 
                    destinationY = centreY1 + Math.sin(angleToDestination) * lengthToDestination;
                }
                removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
                timer.start();
            }
        }
        //白身の座標を作成
        public function createArray():Array {
        var newArray:Array = [];
            for (var i:int; i < 8; i++) {
                var anchor:Number = 90 + Math.floor(Math.random() * 26);
                newArray.push(anchor);
            }
            newArray.push(newArray[0]);
            for (var j:int; j < 8; j++) {
                var control1:Number = newArray[j * 3] / Math.cos(Math.PI / 12);
                var control2:Number = newArray[j * 3 + 1] / Math.cos(Math.PI / 12);
                newArray = newArray.splice(0, j * 3 + 1).concat(control1, control2, newArray);
            }
            return newArray;
        }
    }
}