/**
 * Copyright Sachiko.Otohata ( http://wonderfl.net/user/Sachiko.Otohata )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Qse
 */

package {
    import gs.TweenMax;
    import flash.display.*;
    import flash.events.Event;

    //Draw circles with lights, light circle
    public class FlashTest extends Sprite {
        private static const CIRCLE_STAGE_WIDTH : Number = 550;
        private static const CIRCLE_STAGE_HEIGHT : Number = 400;
        private var _lightGraphic : Sprite;
        private var _stage : Sprite;
        private var TweenTime : Number = 2;
        private var _centerX : Number;
        private var _centerY : Number;
        private var _radius : Number;
        private var _angle : Number;
        private var _degree : Number;
        private var _speed : Number;
        private var _ranNum : Number;
        
        public function FlashTest()  {
            init();
        }
        
        private function init():void{
            prepareStage();
            
            setCircleParams();
            
            addEventListener(Event.ENTER_FRAME, drawLightCircle);
        }

        private function prepareStage() : void {
            _stage = new Sprite();
            _stage.graphics.beginFill(0x000000);
            _stage.graphics.drawRect(0, 0, 1000, 700);
            addChild(_stage);
        }

        private function setCircleParams() : void {
            _centerY = Math.random() * CIRCLE_STAGE_WIDTH;
            _centerX =  Math.random() * CIRCLE_STAGE_HEIGHT;
            
            _ranNum = Math.random() + 0.4;
            _radius = _ranNum * CIRCLE_STAGE_WIDTH/4;
            _speed = _ranNum * 9;
            _degree = 0;
        }
        
        private function drawLightCircle($evt:Event):void{
            createDots();
            calculateDotPosition();
        }
        
        private function createDots():void{
            var dotSprite:Sprite = new Sprite();
            dotSprite.graphics.beginFill(0xFFFF99);
            dotSprite.graphics.drawCircle(0, 0, 20*_ranNum);
            dotSprite.graphics.endFill();
            
            dotSprite.scaleX = _ranNum * 0.6;
            dotSprite.scaleY = _ranNum * 0.6;
            
            dotSprite.alpha = 0;
            TweenMax.to(dotSprite, TweenTime, {scaleX:_ranNum + 0.2, scaleY:_ranNum + 0.2, alpha:1, blurFilter:{blurX:20, blurY:20}});
            TweenMax.to(dotSprite, TweenTime, {scaleX:_ranNum, scaleY:_ranNum, alpha:0, blurFilter:{blurX:0, blurY:0}, delay:TweenTime, onComplete:function():void{removeChild(dotSprite);}});
            addChild(dotSprite);

            _lightGraphic = dotSprite;
        }
        
        private function calculateDotPosition():void{
            
            _angle = _degree * (Math.PI / 180);
            _degree = _degree + _speed;
            
            _lightGraphic.x = _radius * Math.cos(_angle) + _centerX;
            _lightGraphic.y = _radius * Math.sin(_angle) + _centerY;
            
            if (_degree >360) setCircleParams();
        }
        
    }
 
}