/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6QZ3
 */

package
{
    import Box2D.Collision.Shapes.*;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.Joints.*;
    import Box2D.Dynamics.*;    
    import flash.net.*;
    import flash.ui.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;    
    import org.papervision3d.events.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.materials.special.*;    
    [SWF(width="300", height="300", frameRate="15")]
    public class Main extends BasicView
    {
        static public const OBJ_SIZE : int = 40;
        static public const OBJ_NUM : uint = 10;
        static public const OBJ_COLOR : uint = 0x3399FF;
        private var worldWidth : Number;
        private var worldHeight : Number;
        private var m_iterations : int;
        private var m_wallWidth : Number;
        private var m_wallHeight : Number;
        private var m_timeStep : Number;
        private var m_physScale : Number;
        private var m_world : b2World;
        private var m_mouseJoint : b2MouseJoint;
        private var m_draggedBody : b2Body;
        private var mouseXWorldPhys : Number;
        private var mouseYWorldPhys : Number;
        private var isMouseDown : Boolean;
        private var arrayIndex : int;
        private var pv3dObjsArr : Vector.<DisplayObject3D> = new Vector.<DisplayObject3D>(OBJ_NUM, true);
        private var box3dSpapesArr : Vector.<b2Body> = new Vector.<b2Body>(OBJ_NUM, true);
        private var lm : LineMaterial;
        public function Main()
        {
            super(0, 0, true, true);
            createPaervision3dWorld();
            createBox2dWorld()
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            createBackGround();
        }
        private function createPaervision3dWorld() : void
        {
            camera.zoom = 1000 / camera.focus + 1;
            camera.x = 0;
            camera.y = 200;
            camera.z = -1000;
            var light : PointLight3D = new PointLight3D();
            light.z = -100;
            for (var i : int = 0; i < OBJ_NUM; i++)
            { 
                var mat : FlatShadeMaterial
                mat = new FlatShadeMaterial(light, OBJ_COLOR);
                mat.interactive = true;
                var obj3d : DisplayObject3D = scene.addChild(new Sphere(mat, OBJ_SIZE/2, 6, 5));
                obj3d.extra = {radius : OBJ_SIZE, arrayPos : i};
                obj3d.x = - Math.random() * 200 + 100;
                obj3d.y = Math.random() * 80;
                pv3dObjsArr[i] = obj3d;
            }
        }
        private function createBox2dWorld() : void
        {
            worldWidth = stage.stageWidth;
            worldHeight = stage.stageHeight;
            m_iterations = 5;
            m_timeStep = 1 / stage.frameRate;
            m_physScale = 60;
            var worldAABB : b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-1000, -1000);
            worldAABB.upperBound.Set(1000, 1000);
            var gravity : b2Vec2 = new b2Vec2(0, 10);
            var doSleep : Boolean = true;
            m_world = new b2World(worldAABB, gravity, doSleep);
            var wallShapeDef : b2PolygonDef = new b2PolygonDef();
            var wallBodyDef : b2BodyDef = new b2BodyDef();
            var wall : b2Body;
            m_wallWidth = stage.stageWidth;
            m_wallHeight = stage.stageHeight;
            wallShapeDef.SetAsBox(10 / m_physScale, m_wallHeight / 2 / m_physScale);
            wallBodyDef.position.Set(0, m_wallHeight / 2 / m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wallBodyDef.position.Set(m_wallWidth / m_physScale, m_wallHeight / 2 / m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wallShapeDef.SetAsBox(m_wallWidth / 2 / m_physScale, 10 / m_physScale);
            wallBodyDef.position.Set(m_wallWidth / 2 / m_physScale, 0);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wallBodyDef.position.Set(m_wallWidth / 2 / m_physScale, m_wallHeight / m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wall.SetMassFromShapes();
            for (var i : int = 0; i < OBJ_NUM; i++)
            {
                var obj3d : DisplayObject3D = pv3dObjsArr[i];
                var boxShape : b2CircleDef = new b2CircleDef();
                boxShape.radius = OBJ_SIZE / m_physScale / 2;
                boxShape.density = 3;
                boxShape.friction = 10;
                boxShape.restitution = 0.75;
                var bodyDef : b2BodyDef = new b2BodyDef();
                bodyDef.position.Set((obj3d.x + worldWidth / 2) / m_physScale, (obj3d.y + worldHeight / 2) / m_physScale);
                var body : b2Body = m_world.CreateBody(bodyDef);
                body.CreateShape(boxShape);
                body.SetUserData(obj3d);
                body.SetMassFromShapes();
                var vec : b2Vec2 = body.GetLinearVelocity();
                if (i == 5) vec.Set(0, -10);
                //if (i == 0) body.SetLinearVelocity(vec);
                box3dSpapesArr[i] = body;
            }
        } 
        private function enterFrameHandler(event : Event) : void
        {
            m_world.Step(m_timeStep, m_iterations);
            for (var bb : b2Body = m_world.GetBodyList(); bb; bb = bb.GetNext())
            {
                if (bb.GetUserData() is DisplayObject3D)
                {
                    bb.GetUserData().x = bb.GetPosition().x * m_physScale - worldWidth / 2;
                    bb.GetUserData().y = -bb.GetPosition().y * m_physScale + worldHeight / 2;
                    bb.GetUserData().rotationZ = -bb.GetAngle() * (180 / Math.PI);
                }
            }
            singleRender();
        }
        private function createBackGround() : void
        {
            var bgMatrix : Matrix = new Matrix();
            bgMatrix.rotate(90 * Math.PI / 180);
            graphics.beginGradientFill("linear", [0x99ff99, 0x001122], [100, 100], [0, 255], bgMatrix);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        }
    }
}
