/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6QSa
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * tail_y さんのコードを参考に
     * @author paq89
     */
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
    public class Main extends Sprite
    {
        public function Main()
        {
            WonderflTemplate.init(this, init);
        }
        
        private function init():void
        {
            // entry point
        }
    }
    
}

import flash.display.*;
import flash.events.*;

internal class WonderflTemplate extends Object
{
    private static var _stage:Stage;
    private static var _target:DisplayObjectContainer;
    private static var _handler:Function;
    private static var _frameRate:int;
    private static var _background:Shape;
    private static var _backgroundColor:uint;
    
    public static function init(target:DisplayObjectContainer, handler:Function, backgroundColor:uint=0xFFFFFF, frameRate:int = 60):void
    {
        _target = target;
        _handler = handler;
        _frameRate = frameRate;
        _backgroundColor = backgroundColor;
        
        Wonderfl.disable_capture();
        
        _target.addEventListener(Event.ADDED_TO_STAGE, _onAddToStage);
    }
    
    private static function _onAddToStage(event:Event):void
    {
        _target.removeEventListener(Event.ADDED_TO_STAGE, _onAddToStage);
        
        // Stage
        _stage = _target.stage
        _stage.align = StageAlign.TOP_LEFT;
        _stage.scaleMode = StageScaleMode.NO_SCALE;
        _stage.frameRate = _frameRate;
        _stage.addEventListener(Event.RESIZE, _onResize);
        
        // Background
        _background = new Shape();
        _target.addChildAt(_background, 0);
        _onResize();
        
        _handler();
    }
    
    private static function _onResize(event:Event = null):void
    {
        // Background drawing
        var g:Graphics = _background.graphics;
        g.clear();
        g.beginFill(_backgroundColor);
        g.drawRect(0, 0, _stage.stageWidth, _stage.stageHeight);
    }
}