/**
 * Copyright keno42 ( http://wonderfl.net/user/keno42 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6QBw
 */

// forked from bkzen's Dictionary と Object の速度検証（何だこれ）
// forked from bkzen's Dictionary と Object の速度検証
package  
{
    import com.bit101.components.HBox;
    import com.bit101.components.InputText;
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.bit101.components.RadioButton;
    import com.bit101.components.Style;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.Dictionary;
    import flash.utils.getTimer;
    /**
     * Dictionary や Object のアクセス速度の検証。
     * キーがない場合のアクセス速度はかなり気分屋。
     * @author jc at bk-zen
     */
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class Test3 extends Sprite 
    {
        private var dict:     Dictionary;
        private var obj:      Object;
        private var labelD:   InputText;
        private var labelO:   InputText;
        private var labelN:   InputText;
        private var radios:   HBox;
        private var keys:     HBox;
        private var n:        int;
        private var key:      String;
        private var startBtn: PushButton;
        private var m:        int = 0;
        
        public function Test3() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            Style.fontName = "Verdana";
            Style.embedFonts = false;
            Style.fontSize = 10;
            Style.BACKGROUND = 0xEEEEEE;
            
            var i: int, hbox: HBox;
            keys = new HBox(this, 100, 80);
            new RadioButton(keys, 0, 0, "キー無し", true,  onClickK).tag = 0;
            new RadioButton(keys, 0, 0, "キーあり", false, onClickK).tag = 1;
            for (i = 0; i < keys.numChildren; i ++) RadioButton(keys.getChildAt(i)).groupName = "key";
            
            radios = new HBox(this, 100, 100);
            new RadioButton(radios, 0, 0, "7e5", false, onClickN);
            new RadioButton(radios, 0, 0, "6e5", false, onClickN);
            new RadioButton(radios, 0, 0, "5e5", true,  onClickN);
            new RadioButton(radios, 0, 0, "4e5", false, onClickN);
            new RadioButton(radios, 0, 0, "3e5", false, onClickN);
            new RadioButton(radios, 0, 0, "2e5", false, onClickN);
            new RadioButton(radios, 0, 0, "1e5", false, onClickN);
            n = 500000, key = "moja";
            trace(n, int("5e5"));
            
            startBtn = new PushButton(this, 100, 120, "start", onClickStart);
            
            hbox = new HBox(this, 100, 160);
            new Label(hbox, 0, 0, "繰り返し回数\t : ");
            labelN = new InputText(hbox, 0, 0, "500000 回");
            labelN.enabled = false;
            
            hbox = new HBox(this, 100, 180);
            new Label(hbox, 0, 0, "Dictionary\t : ");
            labelD = new InputText(hbox, 0, 0, "****[ms]");
            
            hbox = new HBox(this, 100, 200);
            new Label(hbox, 0, 0, "Object\t\t : ");
            labelO = new InputText(hbox, 0, 0, "****[ms]");
            
        }
        
        private function onClickStart(e: Event):void 
        {
            startBtn.enabled = keys.enabled = radios.enabled = false;
            labelD.text = labelO.text = "wait";
            wait(checkInit);
        }
        
        private function onClickK(e: Event):void 
        {
            var r: RadioButton = e.target as RadioButton;
            key = r.tag ? "piyo" : "moja";
        }
        
        private function onClickN(e: Event):void 
        {
            var r: RadioButton = e.target as RadioButton;
            n = int(r.label);
            labelN.text = n + " 回";
        }
        
        private function checkInit(): void
        {
            m++;
            dict = new Dictionary();
            obj  = { };
            var i: int, s: String;
            for (i = 0; i < n; i ++)
            {
                dict[s = m + "piyo" + i] = "moja";
                obj[s             ] = "moja";
            }
            labelO.text = "check...";
            wait(checkObj);
        }
        
        private function checkDict():void 
        {
            var t: int, i: int, s: String;
            t = getTimer();
            for (i = 0; i < n; i ++) { s = dict[m + key + i]; }
            labelD.text = (getTimer() - t) + " [ms]";
            wait(checkEnd);
        }
        
        private function checkObj():void 
        {
            var t: int, i: int, s: String;
            t = getTimer();
            for (i = 0; i < n; i ++) { s = obj[m + key + i]; }
            labelO.text = (getTimer() - t) + " [ms]";
            labelD.text = "check...";
            wait(checkDict);
        }
        
        private function checkEnd():void 
        {
            startBtn.enabled = keys.enabled = radios.enabled = true;
        }
        
        private function wait(closure: Function): void
        {
            callLater(function(): void
            {
                callLater(closure);
            });
        }
    }
}
//package com.bkzen.utils 
//{
    
    /**
     * あとで一回呼ぶ関数。
     * @author jc at bk-zen.com
     */
    //public function callLater(closure: Function): void
    function callLater(closure: Function): void
    {
        Ticker.add(closure);
    }
//}
import flash.display.Shape;
import flash.events.Event;
internal class Ticker
{
    internal static function add(closure: Function): void
    {
        if (handlers.indexOf(closure) < 0) handlers[cnt++] = closure;
    }
    
    private static var ticker: Shape;
    private static var cnt: int;
    private static var handlers: Array;
    {
        handlers = [];
        ticker = new Shape();
        ticker.addEventListener(Event.ENTER_FRAME, enter);
        //ticker.addEventListener(Event.EXIT_FRAME, enter);
    }
    private static function enter(e:Event):void 
    {
        if (cnt == 0) return;
        var arr: Array = handlers;
        handlers = [], cnt = 0;
        var n: int = arr.length;
        for (var i:int = 0; i < n; i++) 
        {
            arr[i]();
        }
    }
}