/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Pbn
 */

// forked from ProjectNya's Optical Illusion (1)
////////////////////////////////////////////////////////////////////////////////
package {
    import flash.display.Shape;

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import frocessing.color.ColorHSV;
    public class Main extends Sprite {
        
        private static var max:uint = 9;
        private static var center:uint = 95;
        private static var radius:uint = 115;
        private static var speed:Number = 1.5;
        public static var size:int = 25;
        
        private var circle:Shape;
        private var container:Sprite;
        private var circles:Array;
        private static var radian:Number = Math.PI/180;
        
        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            stage.frameRate = 60;
            graphics.clear();
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            container = new Sprite();
            addChild(container);
            container.x = 232;
            container.y = 232;
            //
            circle = new Shape();
            addChildAt(circle,0);
            circle.x = 232;
            circle.y = 232;
            circle.graphics.beginFill(0x0);
            circle.graphics.drawCircle(0,0,100);
            circle.graphics.endFill();
            circle.graphics.lineStyle(5,0x666666);
            circle.graphics.drawCircle(0,0,115);
            circle.graphics.lineStyle(5,0xAAAAAA);
            circle.graphics.drawCircle(0,0,130);
            //
            circles = [];
            var color:ColorHSV = new ColorHSV();
            for (var n:uint = 0; n < max; n ++) {
                var line:Sprite = new Sprite();
                container.addChild(line);
                var angle:Number = (360/max)*n;
                line.rotation = angle;
                color.h = angle;
                var circle:Circle = new Circle(color.value);
                circle.angle = angle*3;
                circle.x = center + radius*Math.sin(circle.angle*radian);
                line.addChild(circle);
                circles.push(circle);
            }
            //
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            container.rotation+=speed;
            
            var x:Number = 0.15 * Math.sin(container.rotation*radian) + .75;
            circle.scaleX = x;
            circle.scaleY = x;
            
            
            for (var n:uint = 0; n < max; n ++) {
                var circle:Circle = circles[n];
                circle.angle += speed;
                circle.x = center + radius*Math.sin(circle.angle*radian);
            }
        }
    }

}


//////////////////////////////////////////////////
// Circle
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import Main;
import flash.display.BlendMode;

class Circle extends Sprite {
    public var id:uint;
    private var color:uint;
    private var _angle:Number = 0;
    private static var radius:uint = Main.size;

    public function Circle(c:uint) {
        color = c;
        init();
    }

    private function init():void {
        var circle:Shape = new Shape();
        circle.graphics.beginFill(color, 1);
        circle.graphics.drawCircle(0, 0, radius);
        circle.graphics.endFill();
        addChild(circle);
        this.blendMode = BlendMode.ADD;
    }
    public function get angle():Number {
        return _angle;
    }
    public function set angle(value:Number):void {
        _angle = (value + 360)%360;
    }

}
