/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6PZZ
 */

// forked from foo9's flash on 2009-12-29
/**
  * @see http://ja.wikipedia.org/wiki/Interpreter_%E3%83%91%E3%82%BF%E3%83%BC%E3%83%B3
  */
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;        
    public class InterpreterPatternSample2 extends Sprite 
    {
        private static const EXPRESSION : String = "42 4 2 - +";        
        private var _parser : Parser;        
        private var _textField : TextField;
        public function InterpreterPatternSample2():void 
        {            
            _parser = new Parser(EXPRESSION);
            _textField = new TextField();
            addChild(_textField);
            _textField.autoSize = TextFieldAutoSize.LEFT;
            _textField.text = "\'" + EXPRESSION + "\'" + " equals " + _parser.evaluate();
        }        
    }
}
interface IExpression 
{
    function interpret(s : Vector.<Number>) : void;
}
class NumberExpression implements IExpression
{
    private var _number : Number;
    public function NumberExpression(number : Number) 
    {    
        _number = number;
    }
    public function interpret(s : Vector.<Number>) : void
    {        
        s.push(_number);            
    }
}    
class PlusExpression implements IExpression
{
    public function PlusExpression() 
    {            
    }
    public function interpret(s : Vector.<Number>) : void
    {        
        s.push(s.pop() + s.pop());
    }
}    
class MinusExpression implements IExpression
{
    public function MinusExpression() 
    {
    }
    public function interpret(s : Vector.<Number>) : void
    {
        s.push(-s.pop() + s.pop());            
    }
}    
class Parser 
{
    private var _parseTree : Vector.<IExpression> = new Vector.<IExpression>();
    public function Parser(s : String) 
    {
        var arr : Array = s.split(" "); 
        for each (var token:String in arr)
        {                
            switch(token)
            {
            case "+":
                _parseTree.push(new PlusExpression());
            break;                    
            case "-":
                _parseTree.push(new MinusExpression());
            break;                    
            default:                        
                _parseTree.push(new NumberExpression(Number(token)));
            }
        }
    }
    public function evaluate() : int
    {
        var _context : Vector.<Number> = new Vector.<Number>();
        for each(var e : IExpression in _parseTree)
        {
            e.interpret(_context);
        }
        return _context.pop();
    }        
}    
