/**
 * Copyright rainafter ( http://wonderfl.net/user/rainafter )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6PLn
 */

// forked from poiasd's スライム forked from: [QuickBox2D] Soft body
// forked from paq's [QuickBox2D] Soft body
package 
{
    import Box2D.Common.Math.b2Vec2;
    import com.actionsnippet.qbox.objects.CircleObject;
    import com.actionsnippet.qbox.QuickBox2D;
    import flash.display.BlendMode;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    
    /**
     * ...
     * @author paq89
     */
    [SWF(backgroundColor="0xFFFFFF", width=465, height=465, frameRate=60)]
    public class Main extends Sprite 
    {
        private var _qbox:QuickBox2D;
        private var _softbody:/*SoftBody*/Array = [];
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            // クオリティーを低に
            //stage.quality = StageQuality.LOW;
            
            // QuickBox2Dを表示するMovieClipを作成
            var mc:MovieClip = new MovieClip();
            addChild(mc);
            
            // QuickBox2Dを作成
            _qbox = new QuickBox2D(mc);
            // 色の設定
            _qbox.setDefault( { lineAlpha:1, fillColor:0xff0000} );
            
            _qbox.createStageWalls();
            _qbox.mouseDrag();
            _qbox.start();
            
            // 箱を2つ作成
            _qbox.addBox( { x:0, y:6, width:2, height:2} );
            //_qbox.addBox( { x:12, y:1, width:2, height:2 } );
            
            // Alphaを0にして見えないようにする
            _qbox.setDefault( { lineAlpha:1, fillAlpha:1} );
            
            for (var i:int = 0; i < 1; i++) 
            {
                _softbody[i] = new SoftBody(_qbox, { x:6, y:7, lineAlpha:0, fillColor:0x2485F3, fillAlpha:0.7, radius:2} );
                addChild(_softbody[i]);
            }
            
            // イベントリスナー
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void 
        {
            for each (var sb:SoftBody in _softbody) 
            {
                sb.update();
            }
        }
        
    }
    
}
import flash.display.Sprite;
import Box2D.Common.Math.b2Vec2;
import com.actionsnippet.qbox.QuickBox2D;
import com.actionsnippet.qbox.objects.CircleObject;
import com.actionsnippet.qbox.QuickObject;

class Anchor extends CircleObject
{
    private var vx:Number = 0;
    private var vy:Number = 0;
    private var spring:Number = 1.5;
    private var friction:Number = 0.1;
    private var vec:b2Vec2;
    public var target:QuickObject;
    private var rot:Number;
        
    public function Anchor(qbox:QuickBox2D, params:Object, target:QuickObject = null, rot:Number = 0)
    {
        super(qbox, params);
        this.target = target;
        this.rot = rot;
        vec = new b2Vec2();
    }
    
    public function update():void
    {
        if (!target) return;
        var targetPos:b2Vec2 = target.body.GetPosition();
        var thisPos:b2Vec2 = body.GetPosition();
        var dx:Number = Math.sin(rot * Math.PI / 180)*2 + targetPos.x - thisPos.x;
        var dy:Number = Math.cos(rot * Math.PI / 180)*2 + targetPos.y - thisPos.y;
        var ax:Number = dx * spring;
        var ay:Number = dy * spring;
        vx += ax;
        vy += ay;
        vec.x = vx;
        vec.y = vy;
        body.ApplyForce(vec, thisPos);
        vx *= friction;
        vy *= friction;
    }
}

class SoftBody extends Sprite
{
    public var params:Object;
    private var _anchor:/*Anchor*/Array = [];
    private var qbox:QuickBox2D;
    
    public function SoftBody(qbox:QuickBox2D, params:Object)
    {
        this.params = params;
        this.qbox = qbox;
        if (this.params.lineColor == null) this.params.lineColor = 1;
        if (this.params.lineAlpha == null) this.params.lineAlpha = 1;
        if (this.params.fillColor == null) this.params.fillColor = 1;
        if (this.params.fillAlpha == null) this.params.fillAlpha = 0;
        if (this.params.radius == null) this.params.radius = 3;
        
        create();
    }
    
    private function create():void
    {
        var rot:Number = 0;
        for (var i:int = 0; i < 18; i++) 
        {
            rot+=20;
            _anchor[i] = new Anchor(qbox, { x:Math.sin(rot * Math.PI / 180) * params.radius + params.x, y:Math.cos(rot * Math.PI / 180) * params.radius + params.y, radius:0.1 }, _anchor[i - 1], rot);
            _anchor[i].shape.m_radius = 0.01* params.radius;
           if (i != 0) qbox.addJoint( { type:QuickBox2D.DISTANCE, a:_anchor[i-1].body, b:_anchor[i].body } );
        }
        
        qbox.addJoint( { type:QuickBox2D.DISTANCE, a:_anchor[0].body, b:_anchor[_anchor.length-1].body } );
    }
    
    public function update():void 
    {
        var len:uint = _anchor.length;
        for (var i:int = 0; i < len; i++) _anchor[i].update();
        graphics.clear();
        graphics.beginFill(params.fillColor, params.fillAlpha);
        graphics.lineStyle(1, params.lineColor, params.lineAlpha);
        var mx:Number = (_anchor[0].x + _anchor[1].x) * 15;
        var my:Number = (_anchor[0].y + _anchor[1].y) * 15;
        graphics.moveTo(mx, my);
        for (i = 1; i < len - 1; i++) 
        {
            mx = (_anchor[i].x + _anchor[i + 1].x) * 15;
            my = (_anchor[i].y + _anchor[i + 1].y) * 15;
          //  graphics.curveTo(_anchor[i].x * 30, _anchor[i].y * 30, mx, my);
            graphics.lineTo(_anchor[i].x * 30, _anchor[i].y * 30);
        }
        mx = (_anchor[0].x + _anchor[1].x) * 15;
        my = (_anchor[0].y + _anchor[1].y) * 15;
       // graphics.curveTo(_anchor[len - 1].x * 30, _anchor[len - 1].y * 30, mx, my);
        graphics.lineTo(_anchor[1].x * 30, _anchor[1].y * 30);
        mx = (_anchor[1].x + _anchor[11].x) * 15;
        my = (_anchor[1].y + _anchor[11].y) * 15;
        graphics.beginFill(0xFFFFFF, 0.9);
        graphics.drawCircle(mx, my, 14);
        graphics.beginFill(0x0, 0.9);
        graphics.drawCircle(mx + 1, my, 7);
        mx = (_anchor[2].x + _anchor[8].x) * 15;
        my = (_anchor[2].y + _anchor[8].y) * 15;
        graphics.beginFill(0xFFFFFF, 0.9);
        graphics.drawCircle(mx, my, 14);
        graphics.beginFill(0x0, 0.9);
        graphics.drawCircle(mx - 1, my, 7);
    }
}