/**
 * Copyright unicdk ( http://wonderfl.net/user/unicdk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6OxC
 */

package {
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    
    public class PokemonAR extends Sprite {
        private const HORIZONTAL_CODES:uint = 2;
        private const VERTICAL_CODES:uint = 2;
        private const AR_PIXELS:uint = 6;
        private const SPACE:uint = 10;
        private const DELAY:uint = 30;
        
        public function PokemonAR():void {
            stage.scaleMode = StageScaleMode.NO_SCALE;
                        
            var scale:int = Math.min(
                (stage.stageWidth - (SPACE*(HORIZONTAL_CODES+1))) / HORIZONTAL_CODES / AR_PIXELS,
                (stage.stageHeight - (SPACE*(VERTICAL_CODES+1))) / VERTICAL_CODES / AR_PIXELS
                );
            
            var bitmaps:Array = new Array(HORIZONTAL_CODES*VERTICAL_CODES);
            
            for( var x:uint = 0, i:uint = 0; x < HORIZONTAL_CODES; x++ )
                for( var y:uint = 0; y < VERTICAL_CODES; y++, i++ )
                {
                    bitmaps[i] = new Bitmap(new BitmapData(AR_PIXELS,AR_PIXELS,false,0));
                    bitmaps[i].scaleX = bitmaps[i].scaleY = scale;
                    bitmaps[i].x = (x * scale * AR_PIXELS) + (SPACE * (x+1));
                    bitmaps[i].y = (y * scale * AR_PIXELS) + (SPACE * (y+1));
                    addChild(bitmaps[i]);
                }
             
             var delay:uint = 0;
             var c:uint = Math.random() * 0x1000;
             var next:Function = function(e:Event):void
             {
                 if( delay-- ) 
                     return ;
                 delay = DELAY;

                 for each( var b:Bitmap in bitmaps )
                     generateAR( c++, b.bitmapData );
             }
             
             addEventListener( Event.ENTER_FRAME, next );
        }

        public function generateAR( code:uint, bd:BitmapData ):void
        {
            var encoded:uint = 
                ((code & 0x01F) << 0) | // Block 0
                ((code & 0x060) << 2) | // Block 1
                ((code & 0x780) << 4) | // Block 2
                ((code & 0x800) ? 0x460 : 0x040); // Control

            var parity:uint = encoded;
            parity ^= parity << 8;
            parity ^= parity << 4;
            parity ^= parity << 2;
            parity ^= parity << 1;

            encoded |= parity & 0x8000;

            for( var y:uint = 1, mask:uint = 1; y < 5; y++ )
                for( var x:uint = 1; x < 5; x++ )
                {
                    bd.setPixel(x,y,(encoded&mask) ? 0xFF000000 : 0xFFFFFFFF );
                    mask <<= 1;
                }
        }
    }
}