/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Oul
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
       
       public var spra:Sprite;
       public var sprb:Sprite;
       
       public var veca:Part = new Part();
       public var vecb:Part = new Part();
      
       
        public function FlashTest() 
        {
            spra = new Sprite();
            sprb = new Sprite();
            
            spra.graphics.clear();
            spra.graphics.lineStyle(2,0);
            spra.graphics.drawCircle(0,0,16);
            
            sprb.graphics.clear();
            sprb.graphics.lineStyle(2,0);
            sprb.graphics.drawCircle(0,0,16);
            
            spra.x = 100;
            spra.y = 100;
            
            sprb.x = 200;
            sprb.y = 100;
            
            addChild(spra);
            addChild(sprb);
            
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, kup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
        public function kdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function kup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
        
        public function onEnter(e:Event):void
        {
            
            veca.vy += 0.1;
            vecb.vy += 0.1;
            
            veca.vx *= 0.99;
            veca.vy *= 0.99;
            
            vecb.vx *= 0.99;
            vecb.vy *= 0.99;
            
            if (vecKey[Keyboard.RIGHT])
            { veca.vx += 0.6;  }
            if (vecKey[Keyboard.LEFT])
            { vecb.vx -= 0.6; }
            
            if (vecKey[Keyboard.UP])
            {
                veca.vy -= 0.4;   
            }
            
            
            //veca.vx += (mouseX - spra.x) * 0.01;
            //veca.vy += (mouseY - spra.y) * 0.01;
            
            if (veca.vy > 0 && spra.y >= 300)
            { spra.y = 300; veca.vy = 0;}
            
            if (vecb.vy > 0 && sprb.y >= 300)
            { sprb.y = 300; vecb.vy = 0; }
            
            conSpring(spra, sprb, veca,vecb, 50);
            
          
            
            spra.x += veca.vx;
            spra.y += veca.vy;
            
            sprb.x += vecb.vx;
            sprb.y += vecb.vy;
            
        }//onenter
        
        public function conSpring(a:Sprite, b:Sprite,
        pa:Part, pb:Part, rest:Number = 50.0):void
        {
            var dx:Number;
            var dy:Number;
            var nx:Number;
            var ny:Number;
            var ax:Number;
            var ay:Number;
            var mag:Number;
            var rem:Number;
            var imp:Number;
            var invma:Number;
            var invmb:Number;
            
            invma = 1.0 / pa.mass;
            invmb = 1.0 / pb.mass;
            
            dx = a.x - b.x;
            dy = a.y - b.y;
            mag = Math.sqrt(dx*dx + dy*dy);
            if (mag == 0) { mag = 0.00000001;}
            
            nx = dx / mag;
            ny = dy / mag;
            
            ax = pa.vx - pb.vx;
            ay = pa.vy - pb.vy;
            
            rem = (ax*nx+ay*ny) + (mag - rest);
            imp = rem / (invma+invmb);
            imp *= 0.5;
            
            pa.vx += imp * (nx*-0.5) * invma;
            pa.vy += imp * (ny*-0.5) * invma;
            pb.vx += imp * (nx*0.5) * invmb;
            pb.vy += imp * (ny*0.5) * invmb;
            
            
        }//spring
         
        
    }//classend
}

internal class Part
{
  public var mass:Number = 1.0;
  public var vx:Number = 0;
  public var vy:Number = 0;
 
 public function Part()
 {}//ctor
    
}//classend

