/**
 * Copyright mimshwright ( http://wonderfl.net/user/mimshwright )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6OeT
 */

package {
	import flash.display.*;
	import flash.geom.*;
	import flash.events.*;
	import flash.text.*;
	import flash.utils.*;
	
	// drawn to bitmap directly
	// Chunky rendering
	// 14fps
		
	[SWF(width="500", height="500", frameRate="50")]
	public class BitmapDrawComparison extends Sprite {
		public var timeDisplay:TextField;
		public var lastTime:int = 0;
		public var bitmap:Bitmap;
		public var bitmapData:BitmapData;
		public var shapeLayer:Sprite;
		
		public function BitmapDrawComparison() {
			addEventListener(Event.ENTER_FRAME, calculateTime);
			
			bitmapData = new BitmapData(500,500,false, 0xFFFFFF);
			bitmap = new Bitmap(bitmapData);
			addChild(bitmap);
			
			shapeLayer = new Sprite();
			 
			var circle:Circle;
			var i:int = 0;
			for (; i < 400; i+=1) {
				circle = new Circle();
				circle.x = 500 * Math.random();
				circle.y = 500 * Math.random();
				circle.cacheAsBitmap = true;
				shapeLayer.addChild(circle);
			}
				
			timeDisplay = new TextField();
			addChild (timeDisplay);
		}
		
		public function calculateTime(event:Event):void {
			bitmapData.fillRect(new Rectangle(0,0,500,500), 0xFFFFFF);
			bitmapData.draw(shapeLayer);
			var now:int = getTimer();
			timeDisplay.text = int(1000/(now - lastTime)) + "fps";
			lastTime = now;
		}
	}
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;

/** Colored circle useded in demo. */ 
internal class Circle extends Sprite {
	public var v:Point;
	
	public function Circle() {
		super();
		
		graphics.beginFill([0xFF00FF,0xFFFF00,0x00FFFF][int(Math.random() * 3)], 1);
		graphics.drawCircle(0, 0, 20);
		blendMode = BlendMode.MULTIPLY;
		
		scaleX = scaleY = .2 + (2 * Math.random());
		
		v = new Point(Math.random() * 2 - 1, Math.random() * 2 - 1);
		
		addEventListener(Event.ENTER_FRAME, update);
	}
	
	private function update(event:Event):void {
		x += v.x;
		y += v.y;
		
		if (x < 0 || x > 500) { v.x = v.x * -1; }
		if (y < 0 || y > 500) { v.y = v.y * -1; }
	}
}