/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6NZM
 */

/*
直前のフレームと比較して色の変化している部分を抜き出す。

両方のフレームをgetPixelして比較している。
Filter類を使うのもいいんだけど、
「早すぎる最適化」でなにをやっているかわからなくなるのも嫌なので、
基本から。


*/
package {
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.*;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.utils.Timer;
	
	public class CameraEx extends Sprite {
		
		private var video:Video;
		private var btn:Sprite;
		private var _bitmapProcess:BitmapProcess;
		
		public function CameraEx() {
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			// camera
			var camera:Camera = Camera.getCamera();
			
			if (camera != null) {
				video = new Video(160, 120);
				video.attachCamera(camera);
				addChild(video);
			} else {
				trace("You need a camera.");
			}
			
			
			_bitmapProcess = new BitmapProcess();
			_bitmapProcess.x = 160;
			this.addChild(_bitmapProcess);
			
						// button
						btn = new Sprite();
						btn.buttonMode = true
						btn.graphics.beginFill(0x333333);
						btn.graphics.drawRect(0,0,100,30);
						btn.y = 120 + 10;            
						addChild(btn);
						btn.addEventListener(MouseEvent.MOUSE_UP, btnUp);
			
			var timer:Timer = new Timer(100,9999);
			timer.addEventListener(TimerEvent.TIMER,onTime);
			timer.start();
		}
		private function onTime(e:TimerEvent):void {
			_bitmapProcess.setBitmap(video);
		}
		
				private function btnUp(e:MouseEvent):void {
					_bitmapProcess.setBitmap(video);
				}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.filters.BitmapFilter;
import flash.filters.BlurFilter;
import flash.filters.ColorMatrixFilter;
import flash.filters.ConvolutionFilter;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.media.Video;

class BitmapProcess extends Sprite{
	private var _bitmap0:Bitmap;
	private var _bitmap1:Bitmap;
	private var _bitmap2:Bitmap;
	private var _bitmapData0:BitmapData;
	private var _bitmapData1:BitmapData;
	private var _bitmapData2:BitmapData;
	private var _tempBitmapData:BitmapData;
	public function BitmapProcess(){
		_bitmapData0 = new BitmapData(160,120,false,0x000000);
		_bitmap0 = new Bitmap(_bitmapData0);
		_bitmap0.scaleX = _bitmap0.scaleY = 2;
		this.addChild(_bitmap0);
		
		_bitmapData1 = new BitmapData(160,120,false,0x000000);
		_bitmap1 = new Bitmap(_bitmapData1);
		_bitmap1.scaleX = _bitmap1.scaleY = 2;
		_bitmap1.y = 240;
		this.addChild(_bitmap1);
		
		_bitmapData2 = new BitmapData(160,120,false,0x000000);
		_bitmap2 = new Bitmap(_bitmapData2);
		_bitmap2.scaleX = _bitmap2.scaleY = 2;
		_bitmap2.y = 500;
		this.addChild(_bitmap2);
				
		_tempBitmapData = new BitmapData(160,120,false,0x000000);
	}
	public function setBitmap(video:Video):void{
//		_bitmapData0.draw(video);
//		_bitmapData0 = outline(_bitmapData0);
		
		_bitmap0.bitmapData = _bitmap2.bitmapData.clone();
		
		//_bitmap2.bitmapData.colorTransform(new Rectangle(0,0,160,120),new ColorTransform(0.5,0.5,0.5,1,0,0,0,0));
		_tempBitmapData.draw(video);
		_bitmap2.bitmapData = _tempBitmapData.clone();
		//_bitmap2.bitmapData.colorTransform(new Rectangle(0,0,160,120),new ColorTransform(0.1,0.1,0.1,1));
		_bitmap2.bitmapData.applyFilter(_bitmap2.bitmapData,_bitmap2.bitmapData.rect,new Point(0,0),new BlurFilter(2,2));
		_bitmap2.bitmapData = posterization(_bitmap2.bitmapData);
		//_bitmap2.bitmapData = outline(_tempBitmapData);
		
		_bitmap1.bitmapData = _bitmap2.bitmapData.clone();
		
//		_bitmap0.bitmapData.draw(_bitmap1,null,null,"difference");
		
		//trace(_bitmap2.bitmapData.getPixel(79,59));
		
		
		_bitmap1.bitmapData.lock();
		_bitmap1.bitmapData.fillRect(new Rectangle(0,0,160,120),0xFF);
		var n:int = _bitmapData0.height;
		var m:int = _bitmapData0.width;
		//var poz:Array = [];
		for (var i:int = 0; i < n; i++) {
			for (var j:int = 0; j < m; j++) {
				if(near(_bitmap0.bitmapData.getPixel(j,i),_bitmap2.bitmapData.getPixel(j,i),8)){
					//poz.push([j,i]);
					
					_bitmap1.bitmapData.setPixel(j,i,_tempBitmapData.getPixel(j,i));
					//_bitmap1.bitmapData.setPixel(j,i,0xFF0000);
				}
			}
		}
		_bitmap1.bitmapData.unlock();
		
		//trace(poz[Math.floor(poz.length/2)]);
		
	}
	private function near(a:uint,b:uint,d:int):Boolean
	{
		
		
		return (a != b);
	}
	
	private function outline(bd:BitmapData):BitmapData
	{
		var matrix:Array = [ -30, 30,  0,
			-30,  30, 0,
			-30, 30,  0];
		var filter:BitmapFilter = new ConvolutionFilter(3,3, matrix, 9);
		var filters:Array = [];
		bd.applyFilter(bd,bd.rect, new Point(0, 0), filter)
		return bd;
	}
	
	public function posterization(bitmapData:BitmapData):BitmapData{
		var n:int = bitmapData.height;
		var m:int = bitmapData.width;
		for (var i:int = 0; i < n; i++) {
			for (var j:int = 0; j < m; j++) {
				var rgb:uint = bitmapData.getPixel(j,i);
				var r:int = rgb >> 16 & 0xFF;
				var g:int = rgb >> 8 & 0xFF;
				var b:int = rgb & 0xFF;
				r = Math.floor(r/64)*64;
				g = Math.floor(g/64)*64;
				b = Math.floor(b/64)*64;
				bitmapData.setPixel(j,i,r*256*256+g*256+b);
			}
		}
		return bitmapData;
	}
	public function getGray(rgb:uint):int{
		var r:int = rgb >> 16 & 0xFF;
		var g:int = rgb >> 8 & 0xFF;
		var b:int = rgb & 0xFF;
		return (r+g+b)/3;
	}
}

