/**
 * Copyright norichika2 ( http://wonderfl.net/user/norichika2 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Mnt
 */

package 
{
	import flash.events.Event;
	import org.papervision3d.materials.special.*;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.materials.*;

	public class Main2 extends BasicView
	{
		//3Dobject
		private var wrap:DisplayObject3D;
		
		//target
		//private var target:DisplayObject3D;
		
		public function Main2() 
		{
			//3Dobject作成
			wrap = new DisplayObject3D;
			scene.addChild(wrap);
			
			//マテリアル作成
			var material:WireframeMaterial = new WireframeMaterial(0x3399FF);
			material.doubleSided = true;
			
			var materials:MaterialsList = new MaterialsList( { all:material } );
			var cube:Cube = new Cube(materials, 300, 300, 300, 10, 10, 10);
			cube.x = 100;
			cube.y = 100;
			cube.z = 100;
			//このlookAtとってみるとlooAtとは何かわかりやすい。
			cube.lookAt(DisplayObject3D.ZERO);
			wrap.addChild(cube);
			
			//原点(0, 0, 0)確認obj
			var yMaterial:WireframeMaterial = new WireframeMaterial(0xFF0000);
			yMaterial.doubleSided = true;
			var objPlane:Plane = new Plane(yMaterial, 10, 10);
			wrap.addChild(objPlane);
			
			//レンダリング
			startRendering();
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void 
		{
			wrap.localRotationY += 1;
		}
		
	}

}