/**
 * Copyright yanbaka ( http://wonderfl.net/user/yanbaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6MXg
 */

package
{
	import caurina.transitions.Tweener;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	
    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	public class Hearts2 extends Sprite
	{
		private const WIDHT:Number = stage.stageWidth;
		private const HEIGHT:Number = stage.stageHeight;
		
		private var _hearts:Array = [];
		private var isDown:Boolean = false;
		
		
		public function Hearts2()
		{
			graphics.beginFill(0x0);
			graphics.drawRect(0, 0, WIDHT, HEIGHT);
			
			for (var i:int=0; i<50; i++)
			{
				var s:Shape = drawHeart();
				var matrix:Matrix = new Matrix();
				matrix.translate(10, 10);
				_hearts[i] = new BitmapData(20, 20, true, 0x0);
				_hearts[i].draw(s, matrix);
			}
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function mouseDownHandler(e:MouseEvent):void
		{
			isDown = true;
		}
		
		private function mouseUpHandler(e:MouseEvent):void
		{
			isDown = false;
		}
		
		private function loop(e:Event):void
		{
			if(isDown) add();
		}
		
		private function add():void
		{
			var max:int = 50;
			var model:Array = createModel(60, 45);
			var times:int = Math.random()*40+10;
			for (var i:int=0; i<max; i++)
			{
				var heart:Heart = new Heart();
				var cnt:int = model[2]/max*i;
				heart.ex = model[0][cnt]*times + mouseX - heart.width/2;
				heart.ey = model[1][cnt]*times + mouseY + heart.height/2;
				var r:int = Math.random()*_hearts.length;
				heart.bitmapData = _hearts[r];
				addChild(heart);
				heart.x = mouseX;
				heart.y = mouseY;
				Tweener.addTween(heart, {delay:i*0.01, x:heart.ex, y:heart.ey, time:0.5, transition:"easeOutBounce", onComplete:end, onCompleteParams:[heart]})
			}
		}
		
		private function end(heart:Heart):void
		{
			Tweener.addTween(heart, {delay:2.0, alpha:0.0, time:0.5, onComplete:del, onCompleteParams:[heart]});
		}
		
		private function del(heart:Heart):void
		{
			removeChild(heart);
		}
		
		private function drawHeart():Shape
		{
			var model:Array = createModel(60, 45);
			var xx:Array = model[0];
			var yy:Array = model[1];
			var imax:int = model[2];
			var times:int = 5;
			
			var shape:Shape = new Shape();
			// ハート書く
			var rc:uint = (Math.random()*0x3F+0xC0)<<16;
			var gc:uint = (Math.random()*0x80)<<8;
			var bc:uint = Math.random()*0x80;
			var c:uint = rc|gc|bc;
			shape.graphics.lineStyle(1, c);
			shape.graphics.beginFill(c, 0.6);
			for (var i:int=0;i<imax;i++)
			{
				if(i == 0)
				{
					shape.graphics.moveTo(xx[i]*times, yy[i]*times);
				}
				else
				{
					shape.graphics.lineTo(xx[i]*times, yy[i]*times);
				}
			}
			
			return shape;
		}
		
		private function createModel(angle:int=60, nb:int=45):Array
		{
			var a:Number = 1;
			var pi:Number = Math.PI;
			var t:Number;
			var dt:Number;
			var r:Number;
			var z:Number;
			var f:Number;
			var radius:Number;
			var b:Number;
			var tmin:Number;
			var tmax:Number;
			var i:int = 0;
			var xx:Array = [];
			var yy:Array = [];
			
			radius = pi*angle/180;
			b = 1.0*nb/100;
			
			tmin=-pi/2;
			tmax=3*pi/2;
			dt=(tmax-tmin)/4000;
			
			for(t=tmin;t<= tmax+dt;t=t+dt)
			{
				if(t>(3*pi/2-dt) && t<(3*pi/2+dt))
				{
					r=0.;
					z=-pi/2;
				}
				else
				{
					if(t>(-pi/2-dt) && t<(-pi/2+dt))
					{
						r=0.;
						z=pi/2;
					}
					else
					{
						r=a*Math.sqrt((5-3*Math.sin(t))*(1+Math.sin(t)));
						z=Math.asin(a*(1-Math.sin(t))*Math.cos(t)/r);
					}
				}
				f=-radius*z/pi+pi/2;
				
				xx[i]=r*Math.cos(f);
				yy[i]=-b*r*Math.sin(f)+a/100;
				i++;
			}
			
			return [xx, yy, i];
		}
	}
}
	import flash.display.Bitmap;

class Heart extends Bitmap
{
	public var ex:Number;
	public var ey:Number;
	
	public function Heart(){}
}