/**
 * Copyright ke_takahashi ( http://wonderfl.net/user/ke_takahashi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6LoP
 */

// forked from Murai's #1 LikeATimeLine WonderflBook Interactive2
package {
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.GlowFilter;
	
	/*
	@author Takashi Murai(KAYAC)
	*/
	
	[SWF(width="465",height="465",backgroundColor="0x000000",frameRate="30")]
	public class WonderflBook extends Sprite {
		
		private var _ball:Sprite;
		private var _startX:Number=0;//xのスタート位置
		private var _endX:Number=stage.stageWidth;//xのエンド位置
		private var _frameCount:uint=0;//再生ヘッド（フレーム数カウント用の変数）
		private var _frameCountLimit:uint=28;//コマ数（最終フレームの位置）
		private var _animationFrames:Array;//フレーム格納用の配列
		
		public function WonderflBook(){
			init();
		}
		
		public function init():void{//初期化メソッド
			_animationFrames=generate_animationFrames();//アニメーションフレームの生成
			
			_ball=new Sprite();//このコードで唯一のグラフィックオブジェクト。画面に表示される_ballです。
			_ball.graphics.lineStyle(1,0x00FFFF);
			_ball.graphics.beginFill(0x00FFFF,0.2);
			_ball.graphics.drawCircle(0,stage.stageHeight/2,5);
			_ball.graphics.endFill();
			//_ball.blendMode=BlendMode.ADD;
			_ball.filters=[new GlowFilter(0x00FFFF,1,16,16,2,2)];
			addChild(_ball);//_ballをDisplayTreeへ登録
			
			start();//レンダリング開始
		}
		
		private function generate_animationFrames():Array{//アニメーションフレームを生成するメソッド
			var tmp:Array=new Array();//出力用の一時的な配列
			var easeRatio:Number=0.2;//イージングの比率
			var tmpX:Number=_startX;
			for(var i:uint=0;i<_frameCountLimit;i++){
				tmpX+=(_endX-tmpX)*easeRatio;
				tmp.push(tmpX);//各コマのx座標をコマ数だけ計算して配列に追加
			}
			return tmp;
		}
		
		private function render(e:Event):void{//レンダリング用のメソッド
			if(_frameCount < _frameCountLimit){//現在のフレーム数が_frameCountLimit以内なら
				_ball.x=_animationFrames[_frameCount];//_ballのxに今のコマ数のx座標を代入
			}else{
				stop();//アニメーション終了
			}
			_frameCount++;//再生ヘッドを進める
		}
		
		public function start():void{addEventListener(Event.ENTER_FRAME,render);};//スタート用のメソッド。renderがENTER_FRAMEのタイミングで実行されるように設定
		public function stop():void{removeEventListener(Event.ENTER_FRAME,render);};//ストップ用のメソッド。renderがENTER_FRAMEのタイミングで実行されるように設定されているのを解除
	}
}

