/**
 * Copyright flashrod ( http://wonderfl.net/user/flashrod )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6Ld7
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    public class Fifteen extends Sprite {
        private static const W:int = 465;
        private static const H:int = 465;
        private static const U:int = int(W/4);
        private static const V:int = int(H/4);
        private var board:Array = [];

        public function Fifteen() {
            for (var k:int = 1; k < 17; ++k) {
                var p:Piece = new Piece(k, U, V);
                addChild(p);
                board.push(p);
            }
            var i:int, j:int = 3;
            for (k = 0; k < 20; ++k) {
                i = int(Math.random()*3);
                shift(i, j);
                j = int(Math.random()*3);
                shift(i, j);
            }
            stage.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
                shift(e.stageX/U, e.stageY/V);
                repaint();
            });
            repaint();
        }
        private function shift(x:int, y:int):void {
            if (x>=0 && x<4 && y>=0 && y<4) {
                for (var i:int = 0; i < 4; ++i) {
                    var p:Piece = board[y*4+i];
                    if (p.value == 16) {
                        for (; i>x; --i)
                            board[y*4+i] = board[y*4+i-1];
                        for (; i<x; ++i)
                            board[y*4+i] = board[y*4+i+1];
                        board[y*4+x] = p;
                        return;
                    }
                }
                for (var j:int = 0; j<4; ++j) {
                    p = board[j*4+x];
                    if (p.value == 16) {
                        for (; j>y; --j)
                            board[j*4+x] = board[(j-1)*4+x];
                        for (; j<y; ++j)
                            board[j*4+x] = board[(j+1)*4+x];
                        board[y*4+x] = p;
                        return;
                    }
                }
            }
        }
        private function repaint():void {
            for (var j:int = 0; j < 4; ++j) {
                for (var i:int = 0; i < 4; ++i) {
                    var p:Piece = board[j*4+i];
                    //p.x = i*U;
                    //p.y = j*V;
                    Tweener.addTween(p, {x:i*U, y:j*V, time:0.1, transition:"easeOutQuad"});
                }
            }
        }
    }
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
class Piece extends Sprite {
    public var value:int;
    public function Piece(value:int, w:int, h:int) {
        this.value = value;
        var fmt:TextFormat = new TextFormat();
        fmt.font = "Verdana";
        fmt.size = Math.min(w, h) * .6;
        var t:TextField = new TextField();
        t.defaultTextFormat = fmt;
        t.text = value < 16 ? String(value) : "";
        t.selectable = false;
        addChild(t);
    }
}
