/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6LJ4
 */

package{
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.filters.*;
    import flash.geom.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.core.data.UserData;
    import org.papervision3d.core.effects.view.ReflectionView;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.events.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.view.BasicView;

    [SWF(backgroundColor="0x303030")]
    public class Sample extends ReflectionView {
        private var bmpData:BitmapData;
        private var drawing:Boolean = false;
        private var sprite:Sprite = new Sprite();
        static private var BITMAP_WIDTH:int = 800;
        static private var SPHERE_SIZE:int = 100;
        static private var SEGMENT:int = 16;

        public function Sample() {
            viewport.interactive = true;
            viewportReflection.filters = [new BlurFilter()];

            bmpData = new BitmapData(BITMAP_WIDTH, BITMAP_WIDTH, true, 0xffffffff);
            var material2:BitmapMaterial = new BitmapMaterial(bmpData);
            material2.interactive = true;
            var obj:Sphere = new Sphere(material2, SPHERE_SIZE, SEGMENT, SEGMENT);

            obj.y = SPHERE_SIZE;
            scene.addChild(obj);

            sprite.graphics.lineStyle(1, 0xff000000);
            for (var i:int = 0; i < SEGMENT; i++) {
                for (var j:int = 0; j < SEGMENT; j++) {
                    //sprite.graphics.moveTo(0, 0);
                    //sprite.graphics.lineTo(BITMAP_WIDTH, 0);
                    var c:int = 0xffffffff;
                    c -= (((i + j) % 2) == 0) ? 0x404040 : 0;
                    var unit:Number = BITMAP_WIDTH / SEGMENT;
                    bmpData.fillRect(new Rectangle(i * unit, j * unit, (i+1) * unit, (j+1) * unit), c);
                }
            }
            bmpData.draw(sprite);

            obj.addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, pressed);
            obj.addEventListener(InteractiveScene3DEvent.OBJECT_MOVE, moved);
            stage.addEventListener(MouseEvent.MOUSE_UP, released);
            addEventListener(Event.ENTER_FRAME, update);
        }

        public function pressed(event:InteractiveScene3DEvent):void {
            drawing = true;
        }
        public function released(event:MouseEvent):void {
            drawing = false;
        }

        public function moved(event:InteractiveScene3DEvent):void {
            var x:Number = event.x;
            var y:Number = event.y;
            if (drawing) {
                var r:Number = BITMAP_WIDTH/2;
                var line_width:Number = r / Math.sqrt(Math.pow(r, 2) - Math.pow(r - y, 2));

                sprite.graphics.lineStyle(5 * line_width, 0xff000000);
                sprite.graphics.lineTo(x, y);
                bmpData.draw(sprite);
            }
            sprite.graphics.moveTo(x, y);
        }

        public function update(e:Event):void {
            //camera.target.y = 100;
            if (!drawing) {
                var camera_length:Number = 400;
                var c:Number = (mouseX / stage.width - 1) * (Math.PI);
                var d:Number = (mouseY / stage.height + 0.5) * (Math.PI / 2 / 2);
                camera.x = Math.sin(c) * Math.cos(d) * camera_length;
                camera.z = Math.cos(c) * Math.cos(d) * camera_length;
                camera.y = Math.sin(d) * camera_length;
            }
            singleRender();
        }
    }
}
