/**
 * Copyright zhanhuode ( http://wonderfl.net/user/zhanhuode )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/6LFX
 */

// forked from bongiovi015's Kuler Invaders
package  {
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.DropShadowFilter;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    
    public class KulerInvader extends Sprite {
    
        //--------------------------------------
        // CLASS CONSTANTS
        //--------------------------------------
        public static const THRESHOLD : Number = 38000;
        public static const MIN_SCALE : Number = .2;
        public static const MAX_SCALE : Number = 1.5;
        public static const W : int = 465;
        public static const H : int = 465;
        public static var COLOR : Array = [];
        
        public static const NAMESPACE_KULER : String = "http://kuler.adobe.com/kuler/API/rss/";
        private static const APIKEY    : String = "4A297340291400B78BF1DFFE0E8E1678";
        
        public var kuler : Namespace = new Namespace(NAMESPACE_KULER);
        private var __bmpdFilled : BitmapData = new BitmapData(W, H, true, 0x00000000);
        private var __aFillers : Array = [];
        private var __loader : URLLoader;
        private var __sContainer : Sprite = new Sprite;
        //--------------------------------------
        //  CONSTRUCTOR
        //--------------------------------------
    
        /**
         *    @constructor
         */
        public function KulerInvader(){
            if(stage) __init();
            else addEventListener( Event.ADDED_TO_STAGE, __init );
            
            var mtx:Matrix = new Matrix;
            mtx.createGradientBox(465, 465, 0);
            graphics.beginGradientFill(GradientType.RADIAL, [0xFFFFFF, 0xD9D9D9], [1, 1], [0, 255], mtx);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
        }

        private function __init(e:Event=null) : void {
            removeEventListener( Event.ADDED_TO_STAGE, __init );
            addChild(__sContainer);
            __sContainer.filters = [new DropShadowFilter(3, 45, 0, .35, 6, 6, 1, 3)];
            
            __loader = new URLLoader();
            __loader.addEventListener(Event.COMPLETE, __onKulerLoadedHandler);
            stage.addEventListener(MouseEvent.CLICK, reset);
            reset();

        }

        
        private function __onKulerLoadedHandler(e:Event) : void {
            var xml:XML = XML(__loader.data);
            COLOR = [];
            var list:XMLList = new XMLList(xml.channel.item);
            var index : int = int(Math.random() * list.length());
            var theme:XML = list[index];
            var swatchList:XMLList = new XMLList(theme.kuler::themeItem.kuler::themeSwatches.kuler::swatch);
            var i : int = 0;
            var colors:Array = [];
            var sColor:String;
            var color:uint
            for(i=0; i<swatchList.length(); i++) {
                sColor = swatchList[i].kuler::swatchHexColor;
                color = parseInt("0x"+sColor);
                COLOR.push(color);
            }
            
            createFiller();
        }
        
        
        private function __loop(e:Event) : void {
            if(__bmpdFilled.histogram()[3][0] < THRESHOLD) {
                stage.removeEventListener(Event.ENTER_FRAME, __loop);
                for each ( var f:Filler in __aFillers) f.stop();
            }
        }
        
        
        public function reset(e:MouseEvent=null) : void {
            for each ( var f:Filler in __aFillers) f.stop();
            __aFillers = [];
            __bmpdFilled.fillRect(new Rectangle(0, 0, W, H) , 0);
            while(__sContainer.numChildren > 0) __sContainer.removeChildAt(0);
            __sContainer.filters = [new DropShadowFilter(3, 45, 0, .35, 6, 6, 1, 3)];
            stage.removeEventListener(Event.ENTER_FRAME, __loop);
            stage.addEventListener(Event.ENTER_FRAME, __loop);
            __loader.load(new URLRequest("http://kuler-api.adobe.com/rss/get.cfm?listType=rating&startIndex=0&itemsPerPage=30&key=" + APIKEY ));
        }
        
        
        public function createFiller(e:Event=null) : void {
            var filler0:Filler = new Filler(__sContainer, __bmpdFilled, true);
            filler0.addEventListener(Filler.END, createFiller);
            var filler1:Filler = new Filler(__sContainer, __bmpdFilled, false);
            filler1.addEventListener(Filler.END, createFiller);
            
            __aFillers.push(filler0);
            __aFillers.push(filler1);
        }
        
    }

}



import caurina.transitions.Tweener;

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.TimerEvent;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.utils.Timer;

class Filler extends EventDispatcher {
    public static const END : String = "fillEnd";
    private var __bmpdFilled : BitmapData;
    private var __isVertical : Boolean;
    private var __spTarget : Sprite;
    private var __pos : Point;
    private var __scale : Number;
    private var __interline : Number;
    private var __index : int = -1;
    public var maxScale : Number = KulerInvader.MAX_SCALE;
    private var __timer:Timer = new Timer(100, 0);
    
    public function Filler( target : Sprite, bmpdFilled : BitmapData, isVertical : Boolean = false ) : void {
        __spTarget = target;
        __bmpdFilled = bmpdFilled;
        __isVertical = isVertical;
        
        __timer.addEventListener(TimerEvent.TIMER, __loop);
        __timer.start();
    }
    
    
    private function __loop(e:Event=null) : void {
        __scale = KulerInvader.MIN_SCALE;
        
        var tx:Number, ty:Number;
        const MAX_TRIES : int = 100;
        var numTry:int = 0;
        var invader:Invader = new Invader(getRandomColorFrom(KulerInvader.COLOR));
        __interline = Invader.WIDTH * KulerInvader.MIN_SCALE;
        
        
        if(__pos != null) {
            tx = __pos.x ;
            ty = __pos.y ;
            if ( __bmpdFilled.getPixel32(tx, ty) != 0x00000000 || __bmpdFilled.hitTest(new Point, 255, new Rectangle(tx, ty, Invader.WIDTH * __scale, Invader.WIDTH * __scale)) || tx + Invader.WIDTH * __scale > 465 || ty + Invader.WIDTH * __scale > 465) {
                dispatchEvent(new Event(END));
                __timer.removeEventListener(TimerEvent.TIMER, __loop);
                __timer.stop();
                return;
            }
        } else {
            do {
                tx = Math.floor(Math.random() * (KulerInvader.W - Invader.WIDTH * __scale) / __interline) * __interline;
                ty = Math.floor(Math.random() * (KulerInvader.H - Invader.WIDTH * __scale) / __interline) * __interline;
                if(numTry++ > MAX_TRIES ) return;
            } while (__bmpdFilled.getPixel32(tx, ty) != 0x00000000 || __bmpdFilled.hitTest(new Point, 255, new Rectangle(tx, ty, Invader.WIDTH * __scale, Invader.WIDTH * __scale)));
            
        }
        
        while( !__bmpdFilled.hitTest(new Point, 255, new Rectangle(tx, ty, Invader.WIDTH * __scale, Invader.WIDTH * __scale) )  && __scale < maxScale && tx + invader.width * __scale < 465 && ty + invader.height * __scale < 465){
            __scale += .05;
        }
        
        
        __scale -= 0.05;
        maxScale = __scale == KulerInvader.MIN_SCALE ? KulerInvader.MIN_SCALE : __scale - 0.25;
        __pos = new Point(tx, ty);
        
        __bmpdFilled.fillRect(new Rectangle(tx, ty, Invader.WIDTH * __scale, Invader.WIDTH * __scale), 0xFFFF0000);
        
        __spTarget.addChild(invader);
        invader.x = tx;
        invader.y = ty;
        invader.alpha = 0;
        invader.scaleX = invader.scaleY = __scale;
        Tweener.addTween(invader, {time:.5, transition:"easeOutSine", alpha:1});
        
        if(__isVertical) __pos.y += Invader.WIDTH * __scale + 1;
        else __pos.x += Invader.WIDTH * __scale + 1;
    }
    
    
    public function stop() : void {
        __spTarget.removeEventListener(Event.ENTER_FRAME, __loop);
        __timer.removeEventListener(TimerEvent.TIMER, __loop);
        __timer.stop();
    }
    
    
    public static function getRandomColorFrom(colors:Array) : uint {    return colors[int(Math.random() * colors.length)];    }
}




import flash.display.BitmapData;
import flash.display.Sprite;


class Invader extends Sprite {
    
    public static const W : int = 10;
    public static const MARGIN : int = 3;
    public static const WIDTH : int = W * 5 + MARGIN * 2;
    
    public var color : uint;
    private var __ary : Array = [];
    
    public function Invader(color:uint) : void {
        this.color = color;
        __init();
    }
    
    
    private function __init() : void {
        var i:int=0, j:int=0;
        var tx:Number, ty:Number;
        
        for(i=0; i<2; i++) {
            for(j=0; j<5; j++) {
                tx = i*W + MARGIN;
                ty = j*W + MARGIN;
                if( Math.random() > .5 ) {
                    graphics.beginFill(color, 1);
                    graphics.drawRect(tx, ty, W, W);
                    graphics.endFill();
                    
                    graphics.beginFill(color, 1);
                    graphics.drawRect(W*4 - tx + MARGIN*2 , ty, W, W);
                    graphics.endFill();
                }
            }
        }
        
        
        for(j=0; j<5; j++) {
            tx = 2*W + MARGIN;
            ty = j*W + MARGIN;
            if( Math.random() > .5 ) {
                graphics.beginFill(color, 1);
                graphics.drawRect(tx, ty, W, W);
                graphics.endFill();
            }
        }
        
    }
    
}
